/*
 * Created on 19-Jan-2005
 */
package kenya.eclipse.ast;

import kenya.errors.KenyaInternalError;
import kenya.passes.Util;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import minijava.node.Node;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

/**
 * @author Thomas Timbul
 */
public class AdvancedPositionFinder {
	
	/**
	 * determines the full location of the given node in the given document.
	 * the document can be null. This does not have an effect on the calculation
	 * except in the case where the node spans multiple lines. This is because of
	 * a limitation in how the nodes' locations are stored.
	 * <br><br>
	 * If doc is null then the result is the location of the first subnode.<br>
	 * 
	 * @param node
	 * @param doc
	 * @return
	 */
	public static ISourceCodeLocation getFullLocation(Node node, IDocument doc) {
		int[] start;
		ISourceCodeLocation end = LastPositionFinder.getLastLocation(node);
		try {
			start = Util.getFirstIdent(node);
		} catch(KenyaInternalError e) {
			return end;
		}
		
		int sline = start[0];
		int scol = start[1];
		
		int eline = end.getLineNumber();
		int ecol = end.getColumnNumber()+end.getTokenLength();
		
		int a, b, c;
		
		if(eline!=sline) {
			if(eline<sline || ecol<=scol || doc==null) {
				//then the end is weird, return the start only
				//or doc is null in which case we can't find the multiline one
				a = sline;
				b = scol;
				c = start[2];
			} else {
				try {
					//use doc for calculation
					a = sline;
					b = scol;
					int startoffset = doc.getLineOffset(sline-1) + scol-1;
					int endoffset = doc.getLineOffset(eline-1) + ecol-1;
					c = endoffset - startoffset;
				} catch(BadLocationException e) {
					a = sline;
					b = 0;
					c = 0;
				}
			}
		} else {
			//subtract
			
			a = sline;
			b = scol;
			c = ecol-scol;
		}
		
		return new SourceCodeLocation(a,b,c);
		
	}
	
	private AdvancedPositionFinder() {}
	}
