/*
 * Created on 18-Mar-2005
 */
package kenya.eclipse.ast;

import minijava.analysis.DepthFirstAdapter;
import minijava.node.Node;
import minijava.node.TIdentifier;

/**
 * @author Thomas Timbul
 */
public class NodeFinder2 extends DepthFirstAdapter {

	/**
	 * 
	 */
	protected NodeFinder2() {
		super();
	}
	
	private String fName;
	
	private TIdentifier fid;
	
	protected NodeFinder2(String name) {
		fName = name;
	}
	
	public TIdentifier getNode() {
		return fid;
	}
	
	/**
	 * finds the the first TIdentifier in root with the given name as its text
	 * Use with caution - this is not a reliable way of finding variables by their name
	 */
	public static TIdentifier perform(Node root, String name) {
		NodeFinder2 finder = new NodeFinder2(name);
		root.apply(finder);
		return finder.getNode();
	}
	
	
	/* (non-Javadoc)
	 * @see minijava.analysis.AnalysisAdapter#caseTIdentifier(minijava.node.TIdentifier)
	 */
	public void caseTIdentifier(TIdentifier node) {
		if(fid!=null) return;
		if(node.getText().equals(fName)) {
			fid = node;
		}
	}
	
	
}
