/*
 * Created on 24-Feb-2005
 */
package kenya.eclipse.ast;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import kenya.io.VariablePushbackReader;
import kenya.sourceCodeInformation.interfaces.IFunction;
import mediator.ICheckedCode;
import minijava.lexer.Lexer;
import minijava.lexer.LexerException;
import minijava.node.Start;
import minijava.parser.Parser;
import minijava.parser.ParserException;

/**
 * @author Thomas Timbul
 */
public class SimpleASTProvider {
	
	SimpleASTProvider() {
		
	}
	
	/**
	 * equivalent to calling<br>
	 * <code>
	 * Reader streamReader = new InputStreamReader(in);<br>
	 * SimpleASTProvider.getAST(streamReader);
	 * </code>
	 * @param in InputStream to read Kenya code from
	 * @return Start containing valid Kenya code or null if the input cannot be parsed
	 */
	public static final Start getAST(InputStream in) {
		if(in!=null)
			return getAST(new InputStreamReader(in));
		return null;
	}
	
	/**
	 * Parses the input from the given reader and returns the corresponding
	 * valid Kenya code. If an exception occurs during parsing, null is
	 * returned instead.
	 * @param in Reader to read input from
	 * @return Start containing valid Kenya code or null if the input cannot be parsed
	 */
	public static final Start getAST(Reader in) {
		try{
    	Parser parser = new Parser(
    	        new Lexer( new VariablePushbackReader(new BufferedReader(in)))
    	);
    	return parser.parse();
    	
    }catch(LexerException e){
        return null;
    }catch(ParserException e){
        return null;
    } catch(IOException e) {
    	return null;
    } catch(NullPointerException e) {
    	return null;
    }
	}
	
	public static final Start getAST(ICheckedCode code) {
		if(code!=null) {
			for(int i = 0; i < code.getFunctions().length; i++) {
				IFunction fun = code.getFunctions()[i];
				return (Start)NodeTools.getParent(fun.getDeclarationNode(), Integer.MAX_VALUE);
			}
		}
		return null;
	}
	
}
