/*
 * Created on 27-Feb-2005
 */
package kenya.eclipse.ast.bindings;

import kenya.eclipse.ast.IBinding;
import kenya.eclipse.ast.NodeTools;

/**
 * @author Thomas Timbul
 */
public class Bindings {

	/**
	 * 
	 */
	private Bindings() {
	}
	
	/**
	 * @param binding
	 * @param target
	 * @return
	 */
	public static boolean equals(IBinding binding, IBinding target) {
		boolean c = binding.getClass()==target.getClass();
		if(!c) return false;
		
		if(binding instanceof BuiltinMethodBinding) {
			return equals((BuiltinMethodBinding)binding, (BuiltinMethodBinding)target);
		}
		if(binding instanceof IInnerVariableBinding) {
			return equals((IInnerVariableBinding)binding, (IInnerVariableBinding)target);
		}
		return
		   binding.getDeclaration().equals(target.getDeclaration())
		&& binding.getDeclaringNode().toString().equals(target.getDeclaringNode().toString())
		&& NodeTools.getLocation(binding.getDeclaringNode())
		            .equals(NodeTools.getLocation(target.getDeclaringNode()))
		;
	}
	
	public static boolean equals(BuiltinMethodBinding binding, BuiltinMethodBinding target) {
		return binding.getDeclaration().equals(target.getDeclaration());
	}
	
	public static boolean equals(IInnerVariableBinding b, IInnerVariableBinding t) {
		return
		b.getDeclaration().equals(t.getDeclaration()) &&
		b.getDeclarer().getName().equals(t.getDeclarer().getName())&&
		b.getDeclarer().equals(t.getDeclarer());
	}
	
}
