/*
 * Created on 28-Feb-2005
 */
package kenya.eclipse.ast.bindings;

import kenya.sourceCodeInformation.interfaces.IClass;
import minijava.node.Node;
import minijava.node.PType;

/**
 * @author Thomas Timbul
 */
public class EnumConstantBinding extends VariableBinding implements IInnerVariableBinding {
	
	private IClass fEnum;
	
	/**
	 * @param node
	 * @param declaringNode
	 * @param type
	 * @param declaration
	 */
	public EnumConstantBinding(Node node, IClass declaringEnum, Node declaringNode, PType type, String declaration) {
		super(node, declaringNode, type, declaration);
		fEnum = declaringEnum;
	}
	
	public String toString() {
		return "[ClassVariableBinding: "+fEnum.getName()+"."+fDeclaration+"]";
	}
	
	public IClass getDeclarer() {
		return fEnum;
	}
	
}
