/*
 * Created on 27-Feb-2005
 */
package kenya.eclipse.ast.bindings;

import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.Node;
import minijava.node.PType;

/**
 * @author Thomas Timbul
 */
public class VariableBinding extends Binding {

	/**
	 * @param node
	 * @param declaringNode
	 * @param declaration
	 */
	public VariableBinding(Node node, Node declaringNode, PType type, String declaration) {
		super(node, declaringNode, type, declaration);
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.ast.IBinding#getKind()
	 */
	public int getKind() {
		return VARIABLE;
	}
	
	public String toString() {
		return "[VariableBinding: "+fDeclaration+"]";
	}
	
	public boolean isArray() {
		return fDeclaringNode instanceof AArrayDecInnerDeclaration;
	}
	
}
