/*
 * Created on 07-Jan-2005
 */
package kenya.eclipse.buildext;

/**
 * @author Thomas Timbul
 */
public interface IKenyaPostBuildAnalyserFactory {
	
	/**
	 * generates an AbstractKenyaPostBuildAnalyser based on the
	 * configuration element passed. This would normally be an instance of
	 * <code>IFile</code> or <code>IResource</code>.<br>
	 * This method <b>must never</b> return null. Instead an Analyser
	 * with empty methods such as 
	 * kenya.eclipse.buildext.NullAnalyser should be returned.
	 * 
	 * @param configElem configuration which influences the creation
	 * @return an AbstractKenyaPostBuildAnalyser configured by configElem
	 */
	public AbstractKenyaPostBuildAnalyser createAnalyser(Object configElem);
	
}
