/*
 * Created on 25-Dec-2004
 */
package kenya.eclipse.debug;

import java.lang.reflect.InvocationTargetException;

import kenya.eclipse.debug.bridge.IBridgeCommunicator;
import kenya.eclipse.debug.bridge.ICommunicationBridge;

/**
 * @author Thomas Timbul
 */
public class DebugVKBridge implements ICommunicationBridge {
	
	protected IBridgeCommunicator commA;
	protected IBridgeCommunicator commB;
	
	/**
	 * 
	 */
	public DebugVKBridge() {
		super();
	}
	
	public void addPort(IBridgeCommunicator comm) {
		setPort(comm, FREE_POSITION);
	}
	
	public void setPort(IBridgeCommunicator comm, int pos) {
		switch(pos) {
			case A_POSITION:
				commA = comm;
				break;
			case B_POSITION:
				commB = comm;
				break;
			case FREE_POSITION:
				if(commA==null) {
					commA = comm;
				} else if(commB==null) {
					commB = comm;
				}
				break;
			default:
				throw new IllegalArgumentException("position other than A,B or FREE not possible");
		}
	}
	
	public Object invokeRemote(IBridgeCommunicator source, String methName, Object[] args) throws InvocationTargetException {
		IBridgeCommunicator target = null;
		if(source==commA) {
			target = commB;
		} else {
			target = commA;
		}
		
		if(target==null) {
			throw new InvocationTargetException(new NullPointerException(), "Bridge target is null.");
		}
		
		return target.invokeRemote(methName, args);
		
	}
	
	
}
