package kenya.eclipse.debug.launcher;

import kenya.eclipse.KenyaPlugin;

/**
 * Constant definitions for Java launch configurations.
 * <p>
 * Constant definitions only; not to be implemented.
 * </p>
 * @since 2.0
 */
public interface IKenyaLaunchConfigurationConstants {

	/**
	 * Identifier for the Kenya Application launch configuration type
	 * (value <code>"kenya.eclipse.KenyaApplication"</code>).
	 */
	public static final String ID_KENYA_APPLICATION = KenyaPlugin.getPluginId() + ".KenyaApplication"; //$NON-NLS-1$
	
	/**
	 * Identifier for the java process type, which is annotated on processes created
	 * by the local java application launch delegate.
	 * 
	 * (value <code>"kenya"</code>).
	 */
	public static final String ID_KENYA_PROCESS_TYPE = "kenya"; //$NON-NLS-1$ 
			
	/**
	 * Launch configuration attribute key. The value is a name of
	 * a Java project associated with a Java launch configuration.
	 */
	public static final String ATTR_PROJECT_NAME = KenyaPlugin.getPluginId() + ".PROJECT_ATTR"; //$NON-NLS-1$
	
	/**
	 * 
	 */
	public static final String ATTR_MAIN_TYPE_NAME = KenyaPlugin.getPluginId() + ".MAIN_TYPE_NAME_ATTR";
	
	/**
	 * Launch configuration attribute key. The value is a boolean specifying
	 * whether execution should stop when main is entered. The default value
	 * is <code>false</code>.
	 * 
	 * @since 2.1
	 */
	public static final String ATTR_STOP_IN_MAIN = KenyaPlugin.getPluginId() + ".STOP_IN_MAIN";	 //$NON-NLS-1$
	
	/**
	 * Launch configuration attribute key. The value is a string specifying
	 * program arguments for a Java launch configuration, as they should appear
	 * on the command line.
	 */
	public static final String ATTR_PROGRAM_ARGUMENTS = KenyaPlugin.getPluginId() + ".PROGRAM_ARGUMENTS"; //$NON-NLS-1$
	
	/**
	 * Launch configuration attribute key. The value is a string specifying a
	 * path to the working directory to use when launching a local VM.
	 * When specified as an absolute path, the path represents a path in the local
	 * file system. When specified as a full path, the path represents a workspace
	 * relative path. When unspecified, the working directory defaults to the project
	 * associated with a launch configuration. When no project is associated with a
	 * launch configuration, the working directory is inherited from the current
	 * process.
	 */
	public static final String ATTR_WORKING_DIRECTORY = KenyaPlugin.getPluginId() + ".WORKING_DIRECTORY";	 //$NON-NLS-1$
	
	/**
	 * Status code indicating a launch configuration does not
	 * specify a project when a project is required.
	 */
	public static final int ERR_UNSPECIFIED_PROJECT = 100;	
		
	/**
	 * Status code indicating a launch configuration does not
	 * specify a main type to launch.
	 */
	public static final int ERR_UNSPECIFIED_MAIN_TYPE = 101;	
		
	/**
	 * Status code indicating the project associated with
	 * a launch configuration is not a Java project.
	 */
	public static final int ERR_NOT_A_JAVA_PROJECT = 107;	
	
	/**
	 * Status code indicating that the project referenced by a launch configuration
	 * is closed.
	 * 
	 * @since 3.0
	 */
	public static final int ERR_PROJECT_CLOSED = 124;			

	/**
	 * Status code indicating an unexpected internal error.
	 */
	public static final int ERR_INTERNAL_ERROR = 150;	

}
