/*
 * Created on 13-Dec-2004
 */
package kenya.eclipse.debug.launcher;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.KenyaRunnerConfiguration;
import mediator.subscription.MediatorInput;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

/**
 * @author Thomas Timbul
 */
public class LaunchConfigurationDelegate implements
		ILaunchConfigurationDelegate {
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ILaunchConfigurationDelegate#launch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {
		
		if (monitor == null) {
			monitor = new NullProgressMonitor();
		}
		
		monitor.beginTask(MessageFormat.format("{0}...", new String[]{configuration.getName()}), 3);
		
		//check for cancellation
		if (monitor.isCanceled()) {
			return;
		}
		
		monitor.subTask("Verifying launch attributes");
		
		//String kenyaClass = 
		
		//look at JavaLocalApplicationLaunchConfigurationDelegate
		
		
		// Program args
		String pgmArgs = getProgramArguments(configuration);
		
		//gather all attributes from configuration and prepare for launch
		
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		
		IProject proj = null;
		{ //just to hide this as i dont need it
			String projName = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
			proj = root.getProject(projName);
		}
		
		if(proj==null) {
			error(IKenyaLaunchConfigurationConstants.ERR_UNSPECIFIED_PROJECT, "project invalid");
		} else if(!proj.isAccessible()) {
			error(IKenyaLaunchConfigurationConstants.ERR_PROJECT_CLOSED, "project is not open");
		}
		
		IFile main = null;
		{
			String type = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null);
			if(type==null) {
				error(IKenyaLaunchConfigurationConstants.ERR_UNSPECIFIED_MAIN_TYPE, "main type not specified");
			}
			IPath path = new Path(type);
			if(path==null) {
				error(IKenyaLaunchConfigurationConstants.ERR_UNSPECIFIED_MAIN_TYPE, "main type invalid");
			} else if(!proj.getFullPath().isPrefixOf(path)) {
				error(IKenyaLaunchConfigurationConstants.ERR_UNSPECIFIED_MAIN_TYPE, "main type in wrong project");
			}
			main = root.getFile(path);
		}
		
		if(main==null || !main.exists()) {
			error(IKenyaLaunchConfigurationConstants.ERR_UNSPECIFIED_MAIN_TYPE, "main type does not exist");
		}
		
		final String workingDir = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, (String)null);
		
		final boolean stopInMain = configuration.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
		
		// check for cancellation
		if (monitor.isCanceled()) {
			return;
		}
		
		//create the mediator input from the Main type
		
		final InputStream contents = main.getContents(); //note: this throws exceptions
		
		MediatorInput input = new MediatorInput() {
			public Reader getReader() {
				return new BufferedReader(new InputStreamReader(contents));
			}
		};
		
		// stop in main
//		prepareStopInMain(configuration);
		
		// done the verification phase
		monitor.worked(1);
		
		//monitor.subTask("Creating source locator...");
		// set the default source locator if required
		//setDefaultSourceLocator(launch, configuration);
		monitor.worked(1);
		
		KenyaRunnerConfiguration c = new KenyaRunnerConfiguration(input);
		c.setArguments(pgmArgs);
		c.setWorkingDirectory(workingDir);
		c.setClassName(main.getFullPath().removeFileExtension().lastSegment());
		c.setProjectName(main.getFullPath().removeLastSegments(1).toString());
		c.setStopInMain(stopInMain);
		
		//	 check for cancellation (its still not too late :p)
		if (monitor.isCanceled()) {
			return;
		}
		
		// Launch the configuration = 1 unit of work
		monitor.subTask("Launching...");
		
		KenyaPlugin.getDefault().getKenyaRunner().run(c, launch, monitor);
		
		
		monitor.done();
		
	}
	
	/**
	 * Returns the program arguments specified by the given launch
	 * configuration, as a string. The returned string is empty if no program
	 * arguments are specified.
	 * 
	 * @param configuration
	 *            launch configuration
	 * @return the program arguments specified by the given launch
	 *         configuration, possibly an empty string
	 * @exception CoreException
	 *                if unable to retrieve the attribute
	 */
	public String getProgramArguments(ILaunchConfiguration configuration)
			throws CoreException {
		String arguments = configuration.getAttribute(
				IKenyaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
		return VariablesPlugin.getDefault().getStringVariableManager()
				.performStringSubstitution(arguments);
	}
	
	protected void error(int code, String message) throws CoreException {
		throw new CoreException(
				new Status(
						Status.ERROR,
						KenyaPlugin.getPluginId(),
						code,
						message,
						null)
					);
	}
	
}
