/*
 * Created on 30-Dec-2004
 */
package kenya.eclipse.debug.model.values;

import kenya.eclipse.debug.model.KVariable;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.sourceCodeInformation.interfaces.IVariable;

import org.eclipse.debug.core.DebugException;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedEnumeration;

/**
 * represents an IEnumType as an IValue in the debugging model
 * @author Thomas Timbul
 */
public class KEnumValue extends KValue {
	
	/*package*/ KEnumValue(KenyaDebugTarget target, IVariable var, IEnumType type) {
		super(target, var);
		fType = type;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getValueString()
	 */
	public String getValueString() throws DebugException {
		return fType.getTypeName();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getVariables()
	 */
	public org.eclipse.debug.core.model.IVariable[] getVariables()
			throws DebugException {
		IInterpretedEnumeration e = ( (IEnumType)fType ).getEnumeration();
		
		Object[] values = e.getValues();
		
		KVariable[] v = new KVariable[0];//values.length];
		
		for(int i=0; i<values.length; i++) {
			//v[i] = null;//new KVariable(fTarget, t[i], fVar); //TODO debugger: getVariables for enums?
			//System.out.println(" "+values[i].getClass().getName());
		}
		
		return v;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#hasVariables()
	 */
	public boolean hasVariables() throws DebugException {
		return ( (IEnumType)fType ).getEnumeration().getValues().length>0;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#isValueEqual(kenya.eclipse.debug.model.values.KValue)
	 */
	public boolean isValueEqual(KValue val) {
		try {
			if(val instanceof KEnumValue) {
				KEnumValue v = (KEnumValue)val;
				boolean eq = ( (IEnumType)fType ).getEnumeration().equals(( (IEnumType)v.fType ).getEnumeration());
				KVariable[] vvars = (KVariable[])v.getVariables();
				KVariable[] vars = (KVariable[])getVariables();
				for(int i=0; i<vvars.length; i++) {
					eq &= vvars[i].isValueEqual(vars[i]);
				}
				
				return eq;
			}
		} catch(DebugException e) {
		}
		return false;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#clone()
	 */
	public Object clone() {
		KEnumValue v = (KEnumValue)super.clone();
		return v;
	}
}
