/*
 * Created on 30-Dec-2004
 */
package kenya.eclipse.debug.model.values;

import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.sourceCodeInformation.interfaces.IVariable;

import org.eclipse.debug.core.DebugException;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;

/**
 * represents an IArrayType as an IValue in the debugging model
 * @author Thomas Timbul
 */
public class KNullValue extends KValue {
	
	/*package*/ KNullValue(KenyaDebugTarget target, IVariable var, INullType type) {
		super(target, var);
		fType = type;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getValueString()
	 */
	public String getValueString() throws DebugException {
		return fType.valueToString();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getVariables()
	 */
	public org.eclipse.debug.core.model.IVariable[] getVariables()
			throws DebugException {
		return new org.eclipse.debug.core.model.IVariable[0];
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#hasVariables()
	 */
	public boolean hasVariables() throws DebugException {
		return false;
	}

	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#isValueEqual(kenya.eclipse.debug.model.values.KValue)
	 */
	public boolean isValueEqual(KValue val) {
		return val instanceof KNullValue;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#clone()
	 */
	public Object clone() {
		KNullValue v = (KNullValue)super.clone();
		return v;
	}
	
}
