/*
 * Created on 25-Dec-2004
 */
package kenya.eclipse.debug.model.values;

import kenya.eclipse.debug.model.KenyaDebugElement;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.sourceCodeInformation.interfaces.IVariable;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;

/**
 * @author Thomas Timbul
 */
public abstract class KValue extends KenyaDebugElement implements IValue, Cloneable {
	
	protected IVariable fVar; //'parent' IVariable (the one that this was created from)
	protected IType fType; //the underlying type of this value
	
	public KValue(KenyaDebugTarget target, IVariable var) {
		super(target);
		fVar = var;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getReferenceTypeName()
	 */
	public String getReferenceTypeName() throws DebugException {
		return fVar.getType().getName();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#isAllocated()
	 */
	public boolean isAllocated() throws DebugException {
		return true;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		return obj!=null && ((obj instanceof KValue && equals((KValue)obj)) || super.equals(obj));
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#equals(kenya.eclipse.debug.model.values.KValue)
	 */
	public boolean equals(KValue obj) {
		try {
			return obj.getClass().equals(getClass())
			    && obj.getReferenceTypeName().equals(getReferenceTypeName())
			    && obj.fVar==fVar
					&& isValueEqual(obj)
					&& obj.getVariables().equals(getVariables());
		} catch(DebugException e) {
			return false;
		}
	}
	
	/**
	 * determines whether two KValue objects have the same underlying value
	 * @param val
	 * @return
	 */
	public abstract boolean isValueEqual(KValue val);
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		int pos = fVar.getPosition().hashCode();
//		int ref = 0;
//		int val = 0;
//		try {
//			ref = getReferenceTypeName().hashCode();
//			val = getValueString().hashCode();
//		} catch(DebugException e) {
//		}
		return pos + fVar.getName().hashCode();
	}
	
	/*
	 *  (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() {
		KValue v;
		try {
			v = (KValue)super.clone();
		} catch(CloneNotSupportedException e) {
			v = KValueFactory.create(fTarget, fVar, fType);
		}
		try {
			v.fType = (IType)fType.clone();
		} catch(CloneNotSupportedException e1) {
			//ignore: see documentation on IType.clone()
		}
		return v;
	}
	
}
