/*
 * Created on 30-Dec-2004
 */
package kenya.eclipse.debug.model.values;

import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.sourceCodeInformation.interfaces.IVariable;

import org.wellquite.kenya.stackMachine.types.interfaces.IArrayType;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IEnumType;
import org.wellquite.kenya.stackMachine.types.interfaces.IGenericType;
import org.wellquite.kenya.stackMachine.types.interfaces.INullType;
import org.wellquite.kenya.stackMachine.types.interfaces.IPrimitiveType;
import org.wellquite.kenya.stackMachine.types.interfaces.IStringType;
import org.wellquite.kenya.stackMachine.types.interfaces.IType;


/**
 * @author Thomas Timbul
 */
public class KValueFactory {
	
	public static KValue create(KenyaDebugTarget target, IVariable var, IType type) {
		if(type instanceof IClassInstanceType){
			return new KClassValue(target, var, (IClassInstanceType)type);
			
		} else if(type instanceof IEnumType) {
			return new KEnumValue(target, var, (IEnumType)type);
			
		} else if(type instanceof IGenericType) {
			return new KGenericValue(target, var, (IGenericType)type);
			
		} else if(type instanceof INullType) {
			return new KNullValue(target, var, (INullType)type);
			
		} else if(type instanceof IArrayType) { //make sure this stays BEFORE IPrimitiveType
			return new KArrayValue(target, var, (IArrayType)type);
			
		} else if(type instanceof IPrimitiveType) {
			return new KPrimitiveValue(target, var, (IPrimitiveType)type);
			
		} else if(type instanceof IStringType) {
			return new KStringValue(target, var, (IStringType)type);
			
		} else {
			return null;
		}
	}
	
}
