/*
 * Created on 17-Feb-2005
 */
package kenya.eclipse.debug.ui;

import java.io.IOException;

import kenya.eclipse.debug.IProcessStreamManager;

import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;

/**
 * @author Thomas Timbul
 * @deprecated Eclipse version 3.1 or higher has introduced its own 'EOF' action, use that instead
 */
public class InsertEOFAction implements IViewActionDelegate {
	
	IConsoleView view;
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {
		this.view = (IConsoleView)view;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		IConsole c = view.getConsole();
		if(c instanceof ProcessConsole) {
			ProcessConsole pc = (ProcessConsole)c;
			
			IDebugTarget dtarget = (IDebugTarget)pc.getProcess().getAdapter(IDebugTarget.class);
			
			if(dtarget==null) {
				return;
			}
			
			IProcessStreamManager man =(IProcessStreamManager)
			    dtarget.getAdapter(IProcessStreamManager.class);
			
			if(man!=null) {
				try {
					man.closeInput();
				} catch(IOException e) {
				}
			}
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

}
