/*
 * Created on 21-Dec-2004
 */
package kenya.eclipse.debug.ui.launchconfig;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.debug.launcher.IKenyaLaunchConfigurationConstants;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * @author Thomas Timbul
 */
public abstract class KenyaLaunchConfigurationTab extends AbstractLaunchConfigurationTab {

	/**
	 * Returns the current IResource context from which to initialize
	 * default settings, or <code>null</code> if none.
	 * 
	 * @return IResource context.
	 */
	protected IResource getContext() {
		IWorkbenchWindow window = KenyaPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
		IWorkbenchPage page = window!=null
		                   ?window.getActivePage()
		                   :null;
		if (page != null) {
			ISelection selection = page.getSelection();
			if (selection instanceof IStructuredSelection) {
				IStructuredSelection ss = (IStructuredSelection)selection;
				if (!ss.isEmpty()) {
					Object obj = ss.getFirstElement();
					if (obj instanceof IResource) {
						return (IResource)obj;
					}
				}
			}
			IEditorPart part = page.getActiveEditor();
			if (part != null) {
				IEditorInput input = part.getEditorInput();
				if(input instanceof IFileEditorInput) {
					return ( (IFileEditorInput)input ).getFile();
				}
				return null;
			}
		}
		return null;
	}

	/**
	 * Set the java project attribute based on the IJavaElement.
	 */
	protected void initializeKenyaProject(IResource javaElement, ILaunchConfigurationWorkingCopy config) {
		IProject javaProject = javaElement.getProject();
		String name = null;
		if (javaProject != null && javaProject.exists()) {
			name = javaProject.getName();
		}
		config.setAttribute(IKenyaLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
	}

	protected static final String EMPTY_STRING = "";

}
