/*
 * Created on 30-Jan-2005
 */
package kenya.eclipse.multieditor.kenya;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import kenya.eclipse.ui.KdtActionConstants;
import kenya.eclipse.ui.KenyaImages;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.search.ui.IContextMenuConstants;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

/**
 * @author Thomas Timbul
 */
public class KenyaEditorActionContributor extends
		BasicTextEditorActionContributor {

	private List fPartListeners= new ArrayList();
	
	protected RetargetAction fRetargetContentAssist;
	protected RetargetTextEditorAction fContentAssist;
	protected RetargetTextEditorAction fContextInformation;
	protected RetargetTextEditorAction fCorrectionAssist;
	
	private ToggleMarkOccurrencesAction fToggleMarkOccurrencesAction;
	
	
	/**
	 * 
	 */
	public KenyaEditorActionContributor() {
		super();
		
		fRetargetContentAssist= new RetargetAction(KdtActionConstants.CONTENT_ASSIST,  KenyaEditorMessages.getString("ContentAssistProposal.label")); //$NON-NLS-1$
		fRetargetContentAssist.setActionDefinitionId(IKenyaEditorActionDefinitionIds.CONTENT_ASSIST_PROPOSALS);
		markAsPartListener(fRetargetContentAssist);
		
		fContentAssist= new RetargetTextEditorAction(KenyaEditorMessages.getResourceBundle(), "ContentAssistProposal."); //$NON-NLS-1$
		fContentAssist.setActionDefinitionId(IKenyaEditorActionDefinitionIds.CONTENT_ASSIST_PROPOSALS); 
		fContentAssist.setImageDescriptor(KenyaImages.DESC_ELCL_CODE_ASSIST);
		fContentAssist.setDisabledImageDescriptor(KenyaImages.DESC_DLCL_CODE_ASSIST);
		
		fContextInformation= new RetargetTextEditorAction(KenyaEditorMessages.getResourceBundle(), "ContentAssistContextInformation."); //$NON-NLS-1$
		fContextInformation.setActionDefinitionId(IKenyaEditorActionDefinitionIds.CONTENT_ASSIST_CONTEXT_INFORMATION);
		
		fCorrectionAssist= new RetargetTextEditorAction(KenyaEditorMessages.getResourceBundle(), "CorrectionAssistProposal."); //$NON-NLS-1$
		fCorrectionAssist.setActionDefinitionId(IKenyaEditorActionDefinitionIds.CORRECTION_ASSIST_PROPOSALS);
		
		fToggleMarkOccurrencesAction= new ToggleMarkOccurrencesAction();
		
	}

	protected final void markAsPartListener(RetargetAction action) {
		fPartListeners.add(action);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorActionBarContributor#init(org.eclipse.ui.IActionBars, org.eclipse.ui.IWorkbenchPage)
	 */
	public void init(IActionBars bars, IWorkbenchPage page) {
		Iterator e= fPartListeners.iterator();
		while (e.hasNext()) 
			page.addPartListener((RetargetAction) e.next());
		
		super.init(bars, page);
		
		bars.setGlobalActionHandler(IKenyaEditorActionDefinitionIds.TOGGLE_MARK_OCCURRENCES, fToggleMarkOccurrencesAction);
		
		// register actions that have a dynamic editor. 
		bars.setGlobalActionHandler(KdtActionConstants.CONTENT_ASSIST, fContentAssist);
		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.texteditor.BasicTextEditorActionContributor#contributeToMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void contributeToMenu(IMenuManager menu) {
		super.contributeToMenu(menu);
		
		IMenuManager editMenu= menu.findMenuUsingPath(IWorkbenchActionConstants.M_EDIT);
		if (editMenu != null) {

			editMenu.add(new Separator(IContextMenuConstants.GROUP_OPEN));			
			editMenu.add(new Separator(IContextMenuConstants.GROUP_GENERATE));
			editMenu.add(new Separator(IContextMenuConstants.GROUP_ADDITIONS));
			
			editMenu.appendToGroup(IContextMenuConstants.GROUP_GENERATE, fRetargetContentAssist);
			editMenu.appendToGroup(IContextMenuConstants.GROUP_GENERATE, fCorrectionAssist);			
			editMenu.appendToGroup(IContextMenuConstants.GROUP_GENERATE, fContextInformation);
		}
		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.texteditor.BasicTextEditorActionContributor#contributeToStatusLine(org.eclipse.jface.action.IStatusLineManager)
	 */
	public void contributeToStatusLine(IStatusLineManager statusLineManager) {
		super.contributeToStatusLine(statusLineManager);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.texteditor.BasicTextEditorActionContributor#setActiveEditor(org.eclipse.ui.IEditorPart)
	 */
	public void setActiveEditor(IEditorPart part) {
		super.setActiveEditor(part);
		
		IActionBars bars = getActionBars();
		IStatusLineManager manager= bars.getStatusLineManager();
		manager.setMessage(null);
		manager.setErrorMessage(null);
		
		ITextEditor textEditor= null;
		if (part instanceof ITextEditor)
			textEditor = (ITextEditor) part;
		else if(part!=null)
			textEditor = (ITextEditor)part.getAdapter(ITextEditor.class);
		
		fToggleMarkOccurrencesAction.setEditor(textEditor);
		
		fContentAssist.setAction(getAction(textEditor, "ContentAssistProposal")); //$NON-NLS-1$
		fContextInformation.setAction(getAction(textEditor, "ContentAssistContextInformation")); //$NON-NLS-1$
		fCorrectionAssist.setAction(getAction(textEditor, "CorrectionAssistProposal")); //$NON-NLS-1$
		
		bars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), getAction(textEditor, IDEActionFactory.ADD_TASK.getId())); //$NON-NLS-1$
		bars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), getAction(textEditor, IDEActionFactory.BOOKMARK.getId())); //$NON-NLS-1$
		
		// Source menu.
		bars.setGlobalActionHandler(KdtActionConstants.COMMENT, getAction(textEditor, "Comment")); //$NON-NLS-1$
		bars.setGlobalActionHandler(KdtActionConstants.UNCOMMENT, getAction(textEditor, "Uncomment")); //$NON-NLS-1$
		bars.setGlobalActionHandler(KdtActionConstants.TOGGLE_COMMENT, getAction(textEditor, "ToggleComment")); //$NON-NLS-1$
		bars.setGlobalActionHandler(KdtActionConstants.FORMAT, getAction(textEditor, "Format")); //$NON-NLS-1$
		bars.setGlobalActionHandler(KdtActionConstants.ADD_BLOCK_COMMENT, getAction(textEditor, "AddBlockComment")); //$NON-NLS-1$
		bars.setGlobalActionHandler(KdtActionConstants.REMOVE_BLOCK_COMMENT, getAction(textEditor, "RemoveBlockComment")); //$NON-NLS-1$
		bars.setGlobalActionHandler(KdtActionConstants.INDENT, getAction(textEditor, "Indent")); //$NON-NLS-1$ //$NON-NLS-2$

	}
	
	/*
	 * @see IEditorActionBarContributor#dispose()
	 */
	public void dispose() {
		
		Iterator e= fPartListeners.iterator();
		while (e.hasNext()) 
			getPage().removePartListener((RetargetAction) e.next());
		fPartListeners.clear();
		
		setActiveEditor(null);
		super.dispose();
	}
	
}
