/*
 * Created on 29-Jan-2005
 */
package kenya.eclipse.multieditor.kenya;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * @author Thomas Timbul
 */
public class KenyaEditorMessages {
	private static final String BUNDLE_NAME = "kenya.eclipse.multieditor.kenya.kenyaEditorMessages";//$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle
			.getBundle(BUNDLE_NAME);

	private KenyaEditorMessages() {
	}

	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch(MissingResourceException e) {
			return '!' + key + '!';
		}
	}

	public static ResourceBundle getResourceBundle() {
		return RESOURCE_BUNDLE;
	}
}