/*
 * Created on 08-Mar-2005
 */
package kenya.eclipse.multieditor.kenya.completion;

import java.util.ArrayList;
import java.util.List;

import kenya.eclipse.ast.NodeTools;
import kenya.eclipse.multieditor.kenya.util.LocationUtils;
import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.AArrayDecInnerDeclaration;
import minijava.node.AClassDecDeclaration;
import minijava.node.AConstDecDeclaration;
import minijava.node.AEnumDecDeclaration;
import minijava.node.AFuncDecDeclaration;
import minijava.node.ATypeName;
import minijava.node.AVarDecInnerDeclaration;
import minijava.node.Start;

/**
 * @author Thomas Timbul
 */
public class VariableDeclarationFinder extends DepthFirstAdapter {
	
	private IFunction ff;
	private ISourceCodeLocation limit;
	private ArrayList list; // <TypeIdentifierPair>
	
	/**
	 * 
	 */
	public VariableDeclarationFinder(IFunction fun, ISourceCodeLocation loc) {
		ff = fun;
		limit = loc;
	}
	
	public List perform() {
		list = new ArrayList();
		ff.getDeclarationNode().apply(this);
		Start st = (Start) NodeTools.getParent(ff.getDeclarationNode(), Integer.MAX_VALUE);
		new ConstantFinder(list).perform(st);
		return list;
	}
	
	public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {
		super.caseAFuncDecDeclaration(node);
	}
	
	public void caseAVarDecInnerDeclaration(AVarDecInnerDeclaration node) {
		ISourceCodeLocation loc = NodeTools.getLocation(node.getIdentifier());
		if(LocationUtils.occursBefore(loc, limit)) {
			list.add(new TypeIdentifierPair(node.getType(), node.getIdentifier(), true));
		}
	}
	
	public void caseAArrayDecInnerDeclaration(AArrayDecInnerDeclaration node) {
		ISourceCodeLocation loc = NodeTools.getLocation(node.getIdentifier());
		if(LocationUtils.occursBefore(loc, limit)) {
			list.add(new TypeIdentifierPair(node.getType(), node.getIdentifier(), true));
		}
	}
	
	public void caseATypeName(ATypeName node) {
		ISourceCodeLocation loc = NodeTools.getLocation(node.getIdentifier());
		if(LocationUtils.occursBefore(loc, limit)) {
			list.add(new TypeIdentifierPair(node.getType(), node.getIdentifier(), true));
		}
	}
	
	public void caseAClassDecDeclaration(AClassDecDeclaration node) {}
	public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {}
}

class ConstantFinder extends DepthFirstAdapter {
	
	private ArrayList list;
	
	public ConstantFinder() {
		list = new ArrayList();
	}
	
	public ConstantFinder(ArrayList list) {
		this.list = list;
	}
	
	public List perform(Start st) {
		st.apply(this);
		return list;
	}
	
	public void caseAConstDecDeclaration(AConstDecDeclaration node) {
		TypeIdentifierPair pair
		  = new TypeIdentifierPair(node.getType(), node.getIdentifier(), false);
		if(!list.contains(pair)) {
			list.add(pair);
		}
	}
	
	public void caseAClassDecDeclaration(AClassDecDeclaration node) {}
	public void caseAFuncDecDeclaration(AFuncDecDeclaration node) {}
	public void caseAEnumDecDeclaration(AEnumDecDeclaration node) {}
	
}