/*
 * Created on 24-Feb-2005
 */
package kenya.eclipse.multieditor.kenya.occurrences;

import java.util.ArrayList;
import java.util.List;

import kenya.eclipse.ast.NodeTools;
import minijava.analysis.ReversedDepthFirstAdapter;
import minijava.node.ABlock;
import minijava.node.AFuncDecDeclaration;
import minijava.node.AReturnStatement;
import minijava.node.Node;
import minijava.node.PName;
import minijava.node.PStatement;
import minijava.node.PStatements;
import minijava.node.PType;
import minijava.node.TIdentifier;
import minijava.node.Token;

/**
 * @author Thomas Timbul
 */
public class MethodExitsFinder extends ReversedDepthFirstAdapter {
	//extend reversed since exits are usually at the back...
	
	private AFuncDecDeclaration fMethodDeclaration;
	private List fResult;
	
	public MethodExitsFinder() {
		super();
	}
	
	/**
	 * initialise with selected node, which should correspond to a return type.
	 * Returns a status message which is null if perform can
	 * be called successfully (node is a return type).
	 * @param node
	 * @return
	 */
	public String initialise(Node node) {
		PType type= null;
		if (node instanceof PType) {
			type= (PType)node;
		} else if(NodeTools.getParent(node, PType.class)!=null) {
			type = (PType)NodeTools.getParent(node, PType.class);
		} else if (node instanceof PName) {
			PName name= NodeTools.getTopMostName((PName)node);
			if (name.parent() instanceof PType) {
				type= (PType)name.parent();
			}
		}
		if (type == null)
			return "No return type selected"; //$NON-NLS-1$
		type= NodeTools.getTopMostType(type);
		if (!(type.parent() instanceof AFuncDecDeclaration))
			return "No return type selected";
		fMethodDeclaration= (AFuncDecDeclaration)type.parent();
		return null;
		
	}
	
	public List perform() {
		fResult= new ArrayList();
		markReferences();
		if (fResult.size() > 0) {
			fResult.add(fMethodDeclaration.getType());
		}
		return fResult;
	}
	
	private void markReferences() {
		fMethodDeclaration.apply(this); //search for returns
		
		ABlock block= (ABlock)fMethodDeclaration.getBlock();
		if (block != null) {
			PStatements statements = block.getStatements();
			PStatement stat = NodeTools.getLastStatement(statements);
			if(stat!=null && stat instanceof AReturnStatement) {
				return; //this has been included in the application above
			}
			//mark the closing curly bracket of the block
			Token brace = block.getRBrace();
			Token t = new TIdentifier("x", brace.getLine(), brace.getPos());
			//x marks the spot - using a new token so others can't modify the brace...
			fResult.add(t);
		}
	}
	
	public void caseAReturnStatement(AReturnStatement node) {
		fResult.add(node);
	}
}
