/*
 * Created on 07-Mar-2005
 */
package kenya.eclipse.multieditor.kenya.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

/**
 * @author Thomas Timbul
 */
public class GroupedArrayList {
	
	//map of names to indices
	protected HashMap fIndex;  // <java.lang.String,java.lang.Integer>
	//map of indices to names
	protected HashMap fbIndex; // <java.lang.Integer,java.lang.String>
	//list of groups - contains ArrayLists
	protected ArrayList groups; // <java.util.ArrayList>
	
	/**
	 * initialise with number of groups
	 * @param n
	 */
	public GroupedArrayList(int n) {
		fIndex = new HashMap(n);
		fbIndex = new HashMap(n);
		groups = new ArrayList(n);
	}
	
	public int getGroupIndex(String name) {
		return ( (Integer)fIndex.get(name) ).intValue();
	}
	
	public String getGroupName(int index) {
		return (String)fbIndex.get(new Integer(index));
	}
	
	public ArrayList getGroup(int index) {
		return (ArrayList)groups.get(index);
	}
	
	public ArrayList getGroup(String name) {
		int group = getGroupIndex(name);
		return (ArrayList)groups.get(group);
	}
	
	public int addGroup(String name) {
		groups.add(new ArrayList());
		int newIndex = groups.size()-1;
		Integer i = new Integer(newIndex); //last in the list
		fIndex.put(name, i);
		fbIndex.put(i, name);
		return newIndex;
	}
	
	public ArrayList deleteGroup(int index) {
		ArrayList al = (ArrayList)groups.remove(index);
		Object name = fbIndex.remove(new Integer(index));
		fIndex.remove(name);
		return al;
	}
	
	public ArrayList deleteGroup(String name) {
		return deleteGroup(getGroupIndex(name));
	}
	
	public void addToGroup(String groupname, Object o) {
		getGroup(groupname).add(o);
	}
	
	public void addAllToGroup(String groupname, Collection c) {
		getGroup(groupname).addAll(c);
	}
	
	public void addAllToGroup(String groupname, Object[] o) {
		addAllToGroup(groupname, Arrays.asList(o));
	}
	
	public void removeFromGroup(String groupname, Object o) {
		getGroup(groupname).remove(o);
	}
	
	public void removeAllFromGroup(String groupname, Collection c) {
		getGroup(groupname).removeAll(c);
	}
	
	public void removeAllFromGroup(String groupname, Object[] o) {
		removeAllFromGroup(groupname, Arrays.asList(o));
	}
	
	public int size() {
		int totalsize = 0;
		for(Iterator it = groups.iterator(); it.hasNext();) {
			ArrayList al = (ArrayList)it.next();
			totalsize += al.size();
		}
		return totalsize;
	}
	
	protected ArrayList getCombinedList() {
		ArrayList merge = new ArrayList(size());
		for(Iterator it = groups.iterator(); it.hasNext();) {
			ArrayList al = (ArrayList)it.next();
			merge.addAll(al);
		}
		return merge;
	}
	
	public Object[] toArray() {
		return getCombinedList().toArray();
	}
	
	public Object[] toArray(Object[] o) {
		return getCombinedList().toArray(o);
	}
	
}
