/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Thomas Timbul - adaptation to Kenya Plugin
 *******************************************************************************/
package kenya.eclipse.multieditor.kenya.util;


import java.util.ArrayList;
import java.util.List;

import kenya.eclipse.KenyaConventions;
import kenya.eclipse.multieditor.util.DefaultSyntaxColorProvider;
import kenya.eclipse.multieditor.util.WhitespaceDetector;
import kenya.eclipse.multieditor.util.WordDetector;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;

/**
 * A Kenya code scanner.
 */
public class KenyaCodeScanner extends RuleBasedScanner {
	
	private static String[] fgKeywords = KenyaConventions.KENYA_KEYWORDS;
	private static String[] fgTypes = KenyaConventions.KENYA_TYPES;
	private static String[] fgConstants = KenyaConventions.KENYA_CONSTANTS;

	/**
	 * Creates a Java code scanner
	 */
	public KenyaCodeScanner(DefaultSyntaxColorProvider provider) {

		IToken keyword= new Token(new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.KEYWORD), null, SWT.BOLD));
		IToken type= new Token(new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.TYPE), null, SWT.BOLD));
		IToken string= new Token(new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.STRING)));
		IToken comment= new Token(new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.SINGLE_LINE_COMMENT)));
		IToken other= new Token(new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.DEFAULT)));
		
		List rules= new ArrayList();

		// Add rule for single line comments.
		rules.add(new EndOfLineRule("//", comment)); //$NON-NLS-1$

		// Add rule for strings and character constants.
		rules.add(new SingleLineRule("\"", "\"", string, '\\')); //$NON-NLS-2$ //$NON-NLS-1$
		rules.add(new SingleLineRule("'", "'", string, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

		// Add generic whitespace rule.
		rules.add(new WhitespaceRule(new WhitespaceDetector()));

		// Add word rule for keywords, types, and constants.
		WordRule wordRule= new WordRule(new WordDetector(), other);
		for (int i= 0; i < fgKeywords.length; i++)
			wordRule.addWord(fgKeywords[i], keyword);
		for (int i= 0; i < fgTypes.length; i++)
			wordRule.addWord(fgTypes[i], type);
		for (int i= 0; i < fgConstants.length; i++)
			wordRule.addWord(fgConstants[i], type);
		rules.add(wordRule);

		IRule[] result= new IRule[rules.size()];
		rules.toArray(result);
		setRules(result);
	}
}
