
/*
 * Created on Aug 10, 2004
 *
 */
package kenya.eclipse.multieditor.util;

import kenya.eclipse.KenyaPlugin;
import mediator.subscription.MediationService;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.SWTException;

/**
 * A customised helper which requests MediationSubscription updates based on
 * DocumentEvents that are received through its DocumentListener,
 * accessible via @link{#getDocumentListener}.
 * 
 * @author Thomas Timbul
 * @version 1
 */
public class KenyaHelperThread extends Job {
	
	private final String subID;
	private boolean stop = false;
	private long lastKeyEvent = 0;
	private DocumentChangeListener lkec;
	
	private long sleepPeriod = 500;
	private long timeout = 1000;
	
	public KenyaHelperThread(String name, String subID) {
		super(name);
		this.subID = subID;
		this.setSystem(true);
	}
	
	public IDocumentListener getDocumentListener() {
		if(lkec==null) {
			lkec = new DocumentChangeListener();
		}
		return lkec;
	}
	
	private void doRequestUpdate() {
		MediationService.getInstance().provideASyncSubscriptionUpdate(subID);
	}
	
	protected boolean itsTimeToParseKenya() {
		return System.currentTimeMillis() > lastKeyEvent + timeout;
	}
	
	public void stoppit() {
		this.stop = true;
		this.wakeUp();
		synchronized(this) {
			this.notifyAll();
		}
	}
	
	public IStatus run(IProgressMonitor monitor) {
		try {
			while (!stop) {
				synchronized(this) {
					//waiting for notification
					try {
						this.wait();
					} catch(InterruptedException e1) {
					}
					
					while(!(stop || itsTimeToParseKenya() )) {
						try {
							this.wait(sleepPeriod); //don't wait more than sleepPeriod
						} catch(InterruptedException e1) {
						}
					}
					if(!stop) {
						doRequestUpdate();
					}
				}
			}
		} catch(SWTException e) {
			KenyaPlugin.log(e);
		} catch(NullPointerException e) {
			//ignore
		}
		return Status.OK_STATUS;
	}
	
	class DocumentChangeListener implements IDocumentListener {
    	
			/* (non-Javadoc)
			 * @see org.eclipse.jface.text.IDocumentListener#documentAboutToBeChanged(org.eclipse.jface.text.DocumentEvent)
			 */
			public void documentAboutToBeChanged(DocumentEvent event) {
				//ignore
			}
			
			/* (non-Javadoc)
			 * @see org.eclipse.jface.text.IDocumentListener#documentChanged(org.eclipse.jface.text.DocumentEvent)
			 */
			public void documentChanged(DocumentEvent event) {
				lastKeyEvent = System.currentTimeMillis();
				synchronized(KenyaHelperThread.this) {
					KenyaHelperThread.this.notifyAll();
				}
			}
    	
    }
}