/*
 * Created on 08-Jan-2005
 */
package kenya.eclipse.style;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.buildext.AbstractKenyaPostBuildAnalyser;
import kenya.eclipse.style.checkerimpl.IStyleChecker;
import mediator.ICheckedCode;
import mediator.IJavaCode;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/**
 * @author Thomas Timbul
 */
public abstract class AbstractStylePostBuildAnalyser extends AbstractKenyaPostBuildAnalyser {
	
	protected abstract IStyleChecker[] getCheckersToExecute();
	
	protected IFile fFile;
	
	private AbstractStylePostBuildAnalyser() {
		super();
	}
	
	/**
	 * 
	 * @param file the file which this checker is executed on
	 */
	public AbstractStylePostBuildAnalyser(IFile file) {
		this();
		fFile = file;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.buildext.IKenyaPostBuildAnalyser#setCheckedCode(mediator.ICheckedCode)
	 */
	public void setCheckedCode(final ICheckedCode code) {
		
		Job run = new Job("KenyaStyleChecking") {
			public IStatus run(IProgressMonitor monitor) {
				
				if(monitor==null) {
					monitor = new NullProgressMonitor();
				}
				
				try {
					fFile.deleteMarkers(KenyaStyleConstants.KENYA_STYLE_MARKER, false, IFile.DEPTH_ZERO);
					KenyaStyleManager.getResolutionManager().clearResolutions(fFile);
				} catch(CoreException e) {
					return Status.OK_STATUS; //this would indicate that the file is not accessible,
					        // so checking is pointless as it involves markers - more exceptions
				}
				
				IStyleChecker[] checkers = getCheckersToExecute();
				int totalWork = 1+checkers.length;
				
				monitor.beginTask(getName(), totalWork);
				
				for(int i = 0; i < checkers.length; i++) {
					
					if(monitor.isCanceled() || !fFile.isAccessible()) {
						return Status.CANCEL_STATUS;
					}
					
					IStyleChecker c = checkers[i];
					monitor.subTask("Executing - "+c.getDescriptor().getName());
					try {
						c.performCheck(code, fFile);
						KenyaStyleManager.getResolutionManager().addResolutions(fFile, c.getMarkerResolutionMap());
					} catch(Exception e) {
						//dont let one of them ruin everything, but log the error
						//e.fillInStackTrace();
						//e.printStackTrace();
						KenyaPlugin.log("Error while executing StyleChecker \""
								+ c.getDescriptor().getName() + "\": " + e, e);
					} finally {
						monitor.worked(1);
					}
					
				}
				
				monitor.worked(1);
				
				return Status.OK_STATUS;
				
			}
			
			
		};
		
		run.setSystem(true);
		run.schedule();
		
	}

	/* (non-Javadoc)
	 * @see kenya.eclipse.buildext.IKenyaPostBuildAnalyser#setJavaCode(mediator.IJavaCode)
	 */
	public void setJavaCode(IJavaCode code) {
		//we dont deal with this
	}
	
}
