/*
 * Created on 26-Jan-2005
 */
package kenya.eclipse.style;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

/**
 * @author Thomas Timbul
 */
public class KenyaStyleResolutionManager implements IMarkerResolutionGenerator2 {
	
	private Map fResolutionMap;
	
	public KenyaStyleResolutionManager() {
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IMarkerResolutionGenerator2#hasResolutions(org.eclipse.core.resources.IMarker)
	 */
	public boolean hasResolutions(IMarker marker) {
		if(this==KenyaStyleManager.getResolutionManager()) {
			return fResolutionMap!=null
			    && fResolutionMap.get(marker.getResource())!=null
					&& ( (Map)fResolutionMap.get(marker.getResource()) ).get(marker)!=null;
		} else {
			return KenyaStyleManager.getResolutionManager().hasResolutions(marker);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IMarkerResolutionGenerator#getResolutions(org.eclipse.core.resources.IMarker)
	 */
	public IMarkerResolution[] getResolutions(IMarker marker) {
		if(this==KenyaStyleManager.getResolutionManager()) {
			if(fResolutionMap!=null) {
				Map m = (Map)fResolutionMap.get(marker.getResource());
				if(m!=null) {
					IMarkerResolution[] resolutions = (IMarkerResolution[])m.get(marker);
					if(resolutions!=null) return resolutions;
				}
			}
			return new IMarkerResolution[0];
		} else {
			return KenyaStyleManager.getResolutionManager().getResolutions(marker);
		}
	}
	
	/**
	 * creates a map of the marker to the array and then calls
	 * <code>addResolutions((IFile)marker.getResource(), map);</code>
	 * @param marker marker to which the set of resolutions applies
	 * @param resolutions resolutions for the given marker
	 */
	void addResolutions(IMarker marker, IMarkerResolution[] resolutions) {
		IFile file = (IFile)marker.getResource();
		HashMap map = new HashMap(1);
		map.put(marker, resolutions);
		addResolutionsWithoutCheck(file, map);
	}
	
	/**
	 * adds the resolutions in the map for a given file.
	 * It is client responsibility to first clear the resolutions
	 * for particular markers in the file or for the entire file if
	 * so desired. This method only appends.
	 * 
	 * @param file file for which to add the markers
	 * @param resolutionMap map of IMarkers to IMarkerResolution[]
	 */
	void addResolutions(IFile file, Map resolutionMap) {
		checkTypes(resolutionMap);
		addResolutionsWithoutCheck(file, resolutionMap);
	}
	
	private void checkTypes(Map map) {
		//ensure that all the values in the map are arrays
		Set s = map.entrySet();
		HashMap ax = new HashMap(s.size());
		for(Iterator it = s.iterator(); it.hasNext();) {
			Map.Entry e = (Map.Entry)it.next();
			if(e.getValue() instanceof IMarkerResolution[]) {
				continue;
			} else if(e.getValue() instanceof IMarkerResolution) {
				IMarkerResolution res = (IMarkerResolution)e.getValue();
				ax.put(e.getKey(), new IMarkerResolution[]{res});
				it.remove();
			} else {
				it.remove(); //cannot add this, its not a resolution!!
			}
		}
		map.putAll(ax);
	}
	
	private void addResolutionsWithoutCheck(IFile file, Map resolutionMap) {
		if(fResolutionMap==null) {
			fResolutionMap = new HashMap();
		}
		
		if(!fResolutionMap.containsKey(file)) {
			HashMap map = new HashMap();
			fResolutionMap.put(file, map);
		}
		
		((Map)fResolutionMap.get(file)).putAll(resolutionMap);
		
	}
	
	/**
	 * removes all registered resolutions for the given file
	 * @param file
	 */
	void clearResolutions(IFile file) {
		if(fResolutionMap!=null && fResolutionMap.containsKey(file)) {
			fResolutionMap.remove(file);
		}
	}
	
	/**
	 * removes all registered solutions for a given marker.
	 * @param marker
	 */
	void clearResolutions(IMarker marker) {
		if(fResolutionMap!=null) {
			Map m = (Map)fResolutionMap.get(marker.getResource());
			if(m!=null) {
				m.remove(marker);
			}
		}
	}
	
}
