/*
 * Created on 07-Jan-2005
 */
package kenya.eclipse.style;

import java.util.Collection;
import java.util.HashMap;

import kenya.eclipse.style.checkerimpl.IStyleChecker;
import kenya.eclipse.style.checkerimpl.IStyleCheckerDescriptor;

import org.eclipse.core.runtime.QualifiedName;

/**
 * @author Thomas Timbul
 */
public class StyleCheckRegistry {
	
	
	protected HashMap fCheckMap = new HashMap();
	
	public StyleCheckRegistry() {
		
	}
	
	public void registerStyleChecker(QualifiedName id, IStyleChecker checker) {
		fCheckMap.put(id, checker);
	}
	
	public void registerStyleChecker(IStyleCheckerDescriptor desc) {
		registerStyleChecker(desc.getID(), desc.getChecker());
	}
	
	public void unregisterStyleChecker(QualifiedName id) {
		fCheckMap.remove(id);
	}
	
	public void unregisterStyleChecker(IStyleCheckerDescriptor desc) {
		unregisterStyleChecker(desc.getID());
	}
	
	public Collection listStyleCheckers() {
		return fCheckMap.values();
	}
	
	public Collection listIds() {
		return fCheckMap.keySet();
	}
	
	public IStyleChecker getStyleChecker(QualifiedName id) {
		return (IStyleChecker)fCheckMap.get(id);
	}
	
	
	
}
