/*
 * Created on 09-Feb-2005
 */
package kenya.eclipse.style;

import kenya.eclipse.multieditor.kenya.refactoring.DocumentModificationOperation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

/**
 * @author Thomas Timbul
 */
public class StyleWarningResolution implements IMarkerResolution2 {
	
	protected String fLabel;
	protected String fDescription;
	protected final IMarker fValidFor; //only valid for this particular marker
	//the operation to apply
	protected final DocumentModificationOperation fOperation;
	
	/**
	 * Creates a new StyleWarningResolution that carries the given label,
	 * is valid for the given marker and has the given
	 * DocumentModificationOperation as its Operation.
	 */
	public StyleWarningResolution(
				String label,
				IMarker marker,
				DocumentModificationOperation operation
			) {
		fLabel = label;
		fValidFor = marker;
		fOperation = operation;
	}
	
	/**
	 * Creates a new StyleWarningResolution that carries the given label,
	 * is valid for the given marker and has as its Operation
	 * a new DocumentModificationOperation that requires no input.
	 * Fully equivalent to
	 * <code>StyleWarningResolution(label, marker, new DocumentModificationOperation())</code>
	 */
	public StyleWarningResolution(String label, IMarker marker) {
		this(label, marker, new DocumentModificationOperation());
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IMarkerResolution2#getDescription()
	 */
	public String getDescription() {
		return fDescription;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IMarkerResolution2#getImage()
	 */
	public Image getImage() {
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IMarkerResolution#getLabel()
	 */
	public String getLabel() {
		return fLabel;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IMarkerResolution#run(org.eclipse.core.resources.IMarker)
	 */
	public void run(IMarker marker) {
		if(marker.equals(fValidFor)) { //can go ahead?
			//get IDocument for the associated resource
			IFile f = (IFile)marker.getResource();
			IFileEditorInput input = new FileEditorInput(f);
			IDocumentProvider provider
			  = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
			IDocument doc = provider.getDocument(input);
			//run the operation
			fOperation.run(doc);
		}
	}
	
}
