/*
 * Created on 08-Jan-2005
 */
package kenya.eclipse.style.checkerimpl;

import org.eclipse.core.runtime.QualifiedName;


/**
 * @author Thomas Timbul
 */
public interface IStyleCheckerDescriptor {
	
	/**
	 * returns the IStyleChecker contained in this definition
	 * @return
	 */
	public IStyleChecker getChecker();
	
	/**
	 * returns the fully qualified id of this Checker 
	 * @return
	 */
	public QualifiedName getID();
	
	/**
	 * returns the human-readable name (will be displayed on screen) for this Checker
	 * @return
	 */
	public String getName();
	
	/**
	 * indicates whether this checker is designed to be enabled by default or not
	 * as specified in its markup by the defaultEnabled attribute
	 * @return a boolean stating whether the checker is to be enabled by default
	 */
	public boolean isDefaultEnabled();
	
}
