/*
 * Created on 21-Jan-2005
 */
package kenya.eclipse.style.checks.magic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import kenya.sourceCodeInformation.interfaces.IFunction;
import mediator.ICheckedCode;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.Node;
import minijava.node.TCharliteral;

import org.eclipse.core.resources.IFile;

/**
 * @author Thomas Timbul
 */
public class MagicCharChecker extends MagicXYZChecker {
	
	private static final String MESSAGE = "The character {0} appears more than once. It would be beneficial to declare it as a constant.";
	
	/**
	 * 
	 */
	public MagicCharChecker() {
		super();
	}

	/* (non-Javadoc)
	 * @see kenya.eclipse.style.checkerimpl.IStyleChecker#configure(java.util.Map)
	 */
	public void configure(Map customAttributes) {
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.style.checkerimpl.IStyleChecker#performCheck(mediator.ICheckedCode, org.eclipse.core.resources.IFile)
	 */
	public void performCheck(final ICheckedCode code, final IFile file) {
		
		IFunction[] functions = code.getFunctions();
		
		//accumulator
		List bigList = new ArrayList();
		
		for(int i = 0; i < functions.length; i++) {
			IFunction fun = functions[i];
			
			//clone the entire tree. This is necessary so we can perform reductions without
			// modifying actual contents
			Node n = (Node)fun.getDeclarationNode().getBlock().clone();
			
			bigList.addAll(CharacterSearch.getChars(n));
			
		}

		step4(file, step3(step2(bigList)), MESSAGE);
		
	}
	
}

class CharacterSearch extends DepthFirstAdapter {
	
	private CharacterSearch() {}
	
	private ArrayList _chars = new ArrayList();
	
	public static List getChars(Node node) {
		
		CharacterSearch search = new CharacterSearch();
		
		node.apply(search);
		
		return search._chars;
	}
	
	public void caseTCharliteral(TCharliteral node) {
		_chars.add(node);
	}
	
}
