/*
 * Created on 21-Jan-2005
 */
package kenya.eclipse.style.checks.magic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import kenya.sourceCodeInformation.interfaces.IFunction;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import mediator.ICheckedCode;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.Node;
import minijava.node.TDpnumber;
import minijava.node.TIntnumber;
import minijava.node.Token;

import org.eclipse.core.resources.IFile;

/**
 * @author Thomas Timbul
 */
public class MagicNumberChecker extends MagicXYZChecker {
	
	private static final String MESSAGE = "The number {0} appears more than once. It would be beneficial to declare it as a constant.";
	
	//these are usually left out because they are used for loops
	private static final List IGNORE_NUMBERS;
	static {
		IGNORE_NUMBERS = new ArrayList();
		IGNORE_NUMBERS.add("1"); //this order is in order of deemed likeliness
		IGNORE_NUMBERS.add("0"); // (minor optimisation that is not really needed)
		IGNORE_NUMBERS.add("-1");
		IGNORE_NUMBERS.add("2");
	}

	/* (non-Javadoc)
	 * @see kenya.eclipse.style.checkerimpl.IStyleChecker#configure(java.util.Map)
	 */
	public void configure(Map customAttributes) {
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.style.checkerimpl.IStyleChecker#performCheck(mediator.ICheckedCode, org.eclipse.core.resources.IFile)
	 */
	public void performCheck(final ICheckedCode code, final IFile file) {
		
		IFunction[] functions = code.getFunctions();
		
		//accumulator
		List bigList = new ArrayList();
		
		for(int i = 0; i < functions.length; i++) {
			IFunction fun = functions[i];
			
			//clone the entire tree. This is necessary so we can perform reductions without
			// modifying actual contents
			Node n = (Node)fun.getDeclarationNode().getBlock().clone();
			
			bigList.addAll(NumberSearch.getNumbers(n));
			
		}
		
		step4(file, step3(step2(bigList)), MESSAGE);
		
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.style.checks.magic.MagicXYZChecker#step2(java.util.List)
	 */
	protected HashMap step2(List bigList) {
		//in this override we also remove the numbers that are supposed to be ignored
		
		//step 2: map the contained text by positions
		HashMap listOfPositions = new HashMap();
		//this Map will contain as values lists of locations where the keys are located 
		
		while(!bigList.isEmpty()) {
			Token t = (Token)bigList.remove(0);
			String text = t.getText();
			
			if(IGNORE_NUMBERS.contains(text)) {
				continue; //don't add this one, its supposed to be ignored
			}
			
			if(!listOfPositions.containsKey(text)) {
				listOfPositions.put(text, new ArrayList(1));
			}
			
			ArrayList al = (ArrayList)listOfPositions.get(text);
			SourceCodeLocation loc
			  = new SourceCodeLocation(t.getLine(), t.getPos(), text.length());
			al.add(loc);
			//dont need to put it back, since its a mutable object and already in the map
		}
		return listOfPositions;
		
	}
	
}

class NumberSearch extends DepthFirstAdapter {
	
	private NumberSearch() {}
	
	private ArrayList _nums = new ArrayList();
	
	public static List getNumbers(Node node) {
		
		NumberSearch search = new NumberSearch();
		
		node.apply(search);
		
		return search._nums;
	}
	
	public void caseTDpnumber(TDpnumber node) {
		_nums.add(node);
	}
	public void caseTIntnumber(TIntnumber node) {
		_nums.add(node);
	}
	
}
