/*
 * Created on 21-Jan-2005
 */
package kenya.eclipse.style.checks.magic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import kenya.sourceCodeInformation.interfaces.IFunction;
import mediator.ICheckedCode;
import minijava.analysis.DepthFirstAdapter;
import minijava.node.Node;
import minijava.node.TStringliteral;

import org.eclipse.core.resources.IFile;

/**
 * @author Thomas Timbul
 */
public class MagicStringChecker extends MagicXYZChecker {
	
	private static final String MESSAGE = "The String literal {0} appears more than once. It would be beneficial to declare it as a constant.";

	/* (non-Javadoc)
	 * @see kenya.eclipse.style.checkerimpl.IStyleChecker#configure(java.util.Map)
	 */
	public void configure(Map customAttributes) {
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.style.checkerimpl.IStyleChecker#performCheck(mediator.ICheckedCode, org.eclipse.core.resources.IFile)
	 */
	public void performCheck(final ICheckedCode code, final IFile file) {
		
		//Strings are contained in functions (duh)
		IFunction[] functions = code.getFunctions();
		
		//accumulator
		List bigList = new ArrayList();
		
		for(int i = 0; i < functions.length; i++) {
			IFunction fun = functions[i];
			
			//clone the entire tree. This is necessary so we can perform reductions without
			// modifying actual contents
			Node n = (Node)fun.getDeclarationNode().getBlock().clone();
			
			bigList.addAll(StringLiteralSearch.getStringLiterals(n));
			
		}
		
		step4(file, step3(step2(bigList)), MESSAGE);
		
	}
	
}

class StringLiteralSearch extends DepthFirstAdapter {
	
	private StringLiteralSearch() {}
	
	private ArrayList _strings = new ArrayList();
	
	public static List getStringLiterals(Node node) {
		
		StringLiteralSearch search = new StringLiteralSearch();
		
		node.apply(search);
		
		return search._strings;
	}
	
	public void caseTStringliteral(TStringliteral node) {
		_strings.add(node);
	}
	
}
