/*
 * Created on 21-Jan-2005
 */
package kenya.eclipse.style.checks.magic;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import kenya.eclipse.style.AutomatedNAVStyleWarningResolution;
import kenya.eclipse.style.StyleWarningResolution;
import kenya.eclipse.style.checkerimpl.AbstractStyleChecker;
import kenya.sourceCodeInformation.interfaces.ISourceCodeLocation;
import kenya.sourceCodeInformation.util.SourceCodeLocation;
import minijava.node.Token;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * @author Thomas Timbul
 */
public abstract class MagicXYZChecker extends AbstractStyleChecker {
	
	/**
	 * 
	 */
	public MagicXYZChecker() {
		super();
	}
	
	/**
	 * Creates a HashMap that maps a Term.getText() to a List of ISourceCodeLocations.
	 * This list contains the locations of where other Terms in bigList are that
	 * have exactly the same .getText()<br>
	 * <b>NOTE:</b> bigList is <b>destroyed</b> in the process!<br>
	 */
	protected HashMap step2(List bigList) {
		//step 2: map the contained text by positions
		HashMap listOfPositions = new HashMap();
		//this Map will contain as values lists of locations where the keys are located 
		
		while(!bigList.isEmpty()) {
			Token t = (Token)bigList.remove(0);
			String text = t.getText();
			
			if(!listOfPositions.containsKey(text)) {
				listOfPositions.put(text, new ArrayList(1));
			}
			
			ArrayList al = (ArrayList)listOfPositions.get(text);
			SourceCodeLocation loc
			  = new SourceCodeLocation(t.getLine(), t.getPos(), text.length());
			al.add(loc);
			//dont need to put it back, since its a mutable object and already in the map
		}
		return listOfPositions;
	}
	
	/**
	 * Removes from the given map any entries that occur less than once.<br>
	 * The returned map is the same instance as is passed in, so care must be
	 * taken when entries are supposed to be retained. In this case a clone
	 * should be passed to this method.
	 */
	protected Map step3(Map map) {
		
		//step 3: examine the map and pick out anything that occurs only once (or less?!?).
		
		for(Iterator it = map.entrySet().iterator(); it.hasNext();) {
			Entry elem = (Entry)it.next();
			
			List l = (List)elem.getValue();
			if(l.size()<2) {
				it.remove();
			}
		}
		
		return map;
	}
	
	/**
	 * creates markers at each of the positions (value) in listOfPositions with MESSAGE,
	 * which is formatted using the String (key) in listOfPositions. accordingly MESSAGE may
	 * only take ONE format argument (as in MessageFormat.format(String, Object[])).
	 * 
	 * @param file
	 * @param listOfPositions
	 * @param MESSAGE
	 */
	protected void step4(final IFile file, final Map listOfPositions, final String MESSAGE) {
		
		//step4: create markers
		IWorkspaceRunnable runnable = new IWorkspaceRunnable() {
			public void run(IProgressMonitor monitor) throws CoreException {
				
				//for each String that is left...
				for(Iterator it = listOfPositions.entrySet().iterator(); it.hasNext();) {
					Entry elem = (Entry)it.next();
					
					String s = (String)elem.getKey();
					List l = (List)elem.getValue();
					
					String msg = MessageFormat.format(MESSAGE,
					    new String[] {s});
					
					//one marker for each position
					for(Iterator iter = l.iterator(); iter.hasNext();) {
						ISourceCodeLocation loc = (ISourceCodeLocation)iter.next();
						IMarker m = createKenyaStyleMarker(file, loc, msg);
						createResolution(m);
					}
				}
			}
		};
		
		runMarkerUpdate(runnable);
		
	}
	
	protected void createResolution(IMarker marker) {
		StyleWarningResolution res = new AutomatedNAVStyleWarningResolution(marker) {
			public String getDescription() {
				return "<p><b>Explanation:</b></p>" +
						"<p>Using a literal expression multiple times means that it has some 'magic' purpose.</p>" +
						"<p>Usually such an expression is a constant value, which does not change frequently, " +
						"but if you ever do want to change the value, " +
						"it can become very tedious, depending on how often it was used.</p>" +
						"<p>You should try to reuse your code by declaring global constants using the " +
						"<b>const</b> keyword. This makes your code much more readable and easier to understand.</p>" +
						"<p><b>Note:</b> the numbers -1, 0, 1 and 2 are usually allowed to appear frequently.</p>";
			}
		};
		if(fResolutionMap==null) {
			fResolutionMap = new HashMap();
		}
		fResolutionMap.put(marker, new StyleWarningResolution[]{res});
	}
	
	
}
