package kenya.eclipse.style.properties;

import kenya.eclipse.KenyaConstants;
import kenya.eclipse.style.KenyaStyleConstants;
import kenya.eclipse.style.KenyaStyleManager;
import kenya.eclipse.style.StyleCheckRegistry;
import kenya.eclipse.style.checkerimpl.IStyleChecker;
import kenya.eclipse.style.ui.StyleCheckListContentProvider;
import kenya.eclipse.style.ui.StyleCheckerLabelProvider;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PropertyPage;

public class StylePropertyPage extends PropertyPage {
	
	private static final String ENABLE_STYLE = "Enable Style Checking";
	
	private static final String DOES_NOT_APPLY_TO_THIS_RESOURCE
	  = "This page does not apply to this resource since it is not contained" +
	  		" in a Kenya project.";
	
	private static final String CHOOSE_CHECKS_DISABLE_ENABLE
	  = "Choose individual checks to enable or disable...";
	
	//the checkbox whether or not checking is enabled
	private Button enabledBox;
	
	private CheckboxTableViewer fCheckViewer;
	private StyleCheckListContentProvider fContentProvider;
	private StyleCheckerLabelProvider fLabelProvider;
	
	private boolean previousEnabledValue;
	private Object[] previousEnabledChecks;
	
	/**
	 * Constructor for StylePropertyPage.
	 */
	public StylePropertyPage() {
		super();
		fContentProvider = new StyleCheckListContentProvider();
		fLabelProvider = new StyleCheckerLabelProvider();
	}
	
	private void addFirstSection(Composite parent) {
		Composite composite = createComposite(parent, 2);
		createEnabledButton(composite);
	}
	
	private void addSeparator(Composite parent) {
		Label separator = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		separator.setLayoutData(gridData);
	}
	
	private void addSecondSection(Composite parent) {
		
		StyleCheckRegistry reg = KenyaStyleManager.getStyleCheckRegistry();
		
		Composite c = createComposite(parent, 1);
		
		Label name = new Label(c, SWT.NONE);
		name.setText(CHOOSE_CHECKS_DISABLE_ENABLE);
		
		GridData data= new GridData(GridData.FILL_BOTH);
		data.heightHint= 10;
		fCheckViewer= CheckboxTableViewer.newCheckList(parent, SWT.BORDER);
		fCheckViewer.getTable().setLayoutData(data);
		fCheckViewer.getTable().setFont(parent.getFont());
		fCheckViewer.setLabelProvider(fLabelProvider);
		fCheckViewer.setContentProvider(fContentProvider);
		fCheckViewer.setInput(reg);
		fCheckViewer.getTable().setEnabled(enabledBox!=null && enabledBox.getSelection());
		
		ViewerSorter v = new ViewerSorter();
		fCheckViewer.setSorter(v);
		
		previousEnabledChecks
		  = PropertyUtils.getFilteredEnabledStyleChecks(getFile(), PropertyUtils.ENABLED, true)
		     .toArray(new IStyleChecker[0]);
		
		fCheckViewer.setCheckedElements(previousEnabledChecks);
	}
	
	private void createEnabledButton(Composite composite) {
		this.enabledBox = new Button(composite, SWT.CHECK | SWT.RIGHT);
		this.enabledBox.setAlignment(SWT.LEFT);
		this.enabledBox.setText(ENABLE_STYLE);
		this.enabledBox.setSelection(this.previousEnabledValue);
		this.enabledBox.setFont(composite.getFont());
		GridData data = new GridData();
		data.horizontalSpan = 2;
		this.enabledBox.setLayoutData(data);
		this.enabledBox.addSelectionListener(new CheckHandler());
	}
	
	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData data = new GridData(GridData.FILL);
		data.grabExcessHorizontalSpace = true;
		composite.setLayoutData(data);
		
		IFile f = getFile();
		
		try {
			if(!f.getProject().hasNature(KenyaConstants.K_NATURE_ID)) {
				Composite c = createComposite(composite, 1);
				Label notApply = new Label(c, SWT.NONE);
				notApply.setText(DOES_NOT_APPLY_TO_THIS_RESOURCE);
				return composite;
			}
		} catch(CoreException e) {
			//ignore
		}
		
		try {
			String enabled = f.getPersistentProperty(KenyaStyleConstants.PROP_STYLE_CHECKING_ENABLED);
			this.previousEnabledValue = (KenyaStyleConstants.ENABLED.equals(enabled));
		} catch(CoreException e1) {
			//ignore
		}
		
		addFirstSection(composite);
		addSeparator(composite);
		addSecondSection(composite);
		
		return composite;
	}
	
	private Composite createComposite(Composite parent, int columns) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = columns;
		composite.setLayout(layout);
		
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		composite.setLayoutData(data);

		return composite;
	}
	
	protected void performDefaults() {
		//enable everything
		enabledBox.setSelection(true);
		int no = fCheckViewer.getTable().getItemCount();
		for(int i = 0; i < no; i++) {
			IStyleChecker o = (IStyleChecker)fCheckViewer.getElementAt(i);
			fCheckViewer.setChecked(o, o.getDescriptor().isDefaultEnabled());
		}
	}
	
	public boolean performOk() {
		// store the values
		try {
			IFile f = getFile();
			f.setPersistentProperty(KenyaStyleConstants.PROP_STYLE_CHECKING_ENABLED, (enabledBox.getSelection())?KenyaStyleConstants.ENABLED:KenyaStyleConstants.DISABLED);
			
			for(int i=0; i<fCheckViewer.getTable().getItemCount(); i++) {
				IStyleChecker c = (IStyleChecker)fCheckViewer.getElementAt(i);
				QualifiedName n = c.getDescriptor().getID();
				String val = fCheckViewer.getChecked(c)
				  ?KenyaStyleConstants.ENABLED
				  :KenyaStyleConstants.DISABLED;
				
				f.setPersistentProperty(n, val);
			}
			
		} catch (CoreException e) {
			return false;
		}
		return true;
	}
	
	private IFile getFile() {
		return (IFile)getElement();
	}
	
	private class CheckHandler implements SelectionListener {
		public void widgetSelected(SelectionEvent event) {
			fCheckViewer.getTable().setEnabled(enabledBox.getSelection());
		}
		
		public void widgetDefaultSelected(SelectionEvent e) {
		}
	}
}