/*
 * Created on 07-Jan-2005
 */
package kenya.eclipse.style.ui;

import java.util.Collection;

import kenya.eclipse.style.StyleCheckRegistry;
import kenya.eclipse.style.checkerimpl.IStyleChecker;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * @author Thomas Timbul
 */
public class StyleCheckListContentProvider implements
		IStructuredContentProvider {
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		if(inputElement instanceof StyleCheckRegistry) {
			StyleCheckRegistry registry = (StyleCheckRegistry)inputElement;
			
			Collection c = registry.listStyleCheckers();
			
			return (IStyleChecker[])c.toArray(new IStyleChecker[c.size()]);
		}
		return new IStyleChecker[0];
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}
	
}
