/*
 * Created on 12-Nov-2004
 */
package kenya.eclipse.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;

import kenya.eclipse.KenyaConstants;
import kenya.eclipse.KenyaPlugin;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 *               Thomas Timbul - adaptation to KDT
 ******************************************************************************/
public class KenyaImages {
	
	private static final String NAME_PREFIX = KenyaConstants.K_PLUGIN_ID + ".";
	private static final int NAME_PREFIX_LENGTH = NAME_PREFIX.length();
	private static final String ICON_PATH_PREFIX = "icons/full/";
	
	private static URL fgIconBaseURL = null;
	
	static {
		String pathSuffix = ICON_PATH_PREFIX;
		fgIconBaseURL = KenyaPlugin.getDefault().getBundle().getEntry(pathSuffix);
	}
	
	private static final String BANNER = "wizban/";  //folder for wizard banners
	private static final String DLCL   = "dlcl16"; 	 //disabled
	private static final String ELCL   = "elcl16"; 	 //enabled
	private static final String OBJECT = "obj16/";   //folder for object images
	private static final String OVR    = "ovr16/";   //folder for overlay images
	private static final String ETOOL  = "etool16/";  //folder for enabled tool images
	private static final String VIEW   = "eview16/"; //folder for view images

	private KenyaImages() {
		//prevent instantiation
	}
	
	public static Image getImage(String key) {
		return getImageRegistry().get(key);
	}
	
	static ImageRegistry getImageRegistry() {
		if (fgImageRegistry == null) {
			fgImageRegistry = new ImageRegistry();
			for(Iterator iter = fgAvoidSWTErrorMap.keySet().iterator(); iter
					.hasNext();) {
				String key = (String)iter.next();
				fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap
						.get(key));
			}
			fgAvoidSWTErrorMap = null;
		}
		return fgImageRegistry;
	}
	
	/**
	 * Sets the three image descriptors for enabled, disabled, and hovered to an action. The actions
	 * are retrieved from the *tool16 folders.
	 * 
	 * @param action	the action
	 * @param iconName	the icon name
	 */
	public static void setToolImageDescriptors(IAction action, String iconName) {
		setImageDescriptors(action, "tool16", iconName); //$NON-NLS-1$
	}
	/**
	 * Sets the three image descriptors for enabled, disabled, and hovered to an action. The actions
	 * are retrieved from the *lcl16 folders.
	 * 
	 * @param action	the action
	 * @param iconName	the icon name
	 */
	public static void setLocalImageDescriptors(IAction action, String iconName) {
		setImageDescriptors(action, "lcl16", iconName); //$NON-NLS-1$
	}
	private static void setImageDescriptors(IAction action, String type, String relPath) {
		
		try {
			ImageDescriptor id= ImageDescriptor.createFromURL(makeIconFileURL("d" + type, relPath)); //$NON-NLS-1$
			if (id != null)
				action.setDisabledImageDescriptor(id);
		} catch (MalformedURLException e) {
		}
	
		/*
		try {
			ImageDescriptor id= ImageDescriptor.createFromURL(makeIconFileURL("c" + type, relPath)); //$NON-NLS-1$
			if (id != null)
				action.setHoverImageDescriptor(id);
		} catch (MalformedURLException e) {
		}
		*/
	
		ImageDescriptor descriptor= create("e" + type, relPath); //$NON-NLS-1$
		action.setHoverImageDescriptor(descriptor);
		action.setImageDescriptor(descriptor); 
	}
	
	/* helper methods (access icons on file system)*/
	private static ImageDescriptor createManaged(final String prefix, final String name) {
		try {
			ImageDescriptor result = ImageDescriptor
					.createFromURL(makeIconFileURL(prefix, name
							.substring(NAME_PREFIX_LENGTH)));
			if (fgAvoidSWTErrorMap == null) {
				fgAvoidSWTErrorMap = new HashMap();
			}
			fgAvoidSWTErrorMap.put(name, result);
			if (fgImageRegistry != null) {
				KenyaPlugin
						.log("Internal Error: Image registry already defined");
			}

			return result;
		} catch(MalformedURLException e) {
			KenyaPlugin.log(e);
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}
	private static ImageDescriptor create(String prefix, String name) {
		try {
			return ImageDescriptor.createFromURL(makeIconFileURL(prefix, name));
		} catch(MalformedURLException e) {
			KenyaPlugin.log(e);
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}
	private static URL makeIconFileURL(String prefix, String name)
			throws MalformedURLException {
		if (fgIconBaseURL == null)
			throw new MalformedURLException();

		StringBuffer buffer = new StringBuffer(prefix);
		//buffer.append('/');
		buffer.append(name);
		return new URL(fgIconBaseURL, buffer.toString());
	}
	
	//The plugin registry
	private static ImageRegistry fgImageRegistry = null;

	private static HashMap fgAvoidSWTErrorMap = null;
	
	
	
	public static final String IMG_OBJ_K_PROJECT = NAME_PREFIX + "k2project_obj.png";
	public static final String IMG_OBJ_K_FILE = NAME_PREFIX + "k2cu_obj.png";
	public static final String IMG_OBJ_CLASS = NAME_PREFIX + "class_obj.gif";
	
	public static final String IMG_OBJ_KENYA_APP = NAME_PREFIX + "kenya_app.png";
	public static final String IMG_OBJ_FIELD_PUBLIC = NAME_PREFIX + "field_public_obj.gif";
	public static final String IMG_OBJ_METH_PUBLIC = NAME_PREFIX + "methpub_obj.gif";
	public static final String IMG_OBJ_VAR_LOCAL = NAME_PREFIX + "localvariable_obj.gif";
	
	public static final String IMG_WIZ_NPROJ = NAME_PREFIX + "newk2prj_wiz.png";
	public static final String IMG_WIZBAN_NPROJ = NAME_PREFIX + "newkprj_wiz.png";
	public static final String IMG_VIEW_VARIABLE_TAB = NAME_PREFIX + "variable_tab.gif";
	
	
	
	public static final ImageDescriptor DESC_K_PROJECT = createManaged(OBJECT, IMG_OBJ_K_PROJECT);
	public static final ImageDescriptor DESC_K_FILE = createManaged(OBJECT, IMG_OBJ_K_FILE);
	public static final ImageDescriptor DESC_K_NPROJ_WIZ = createManaged(ETOOL, IMG_WIZ_NPROJ);
	public static final ImageDescriptor DESC_K_NPROJ_WIZBAN = createManaged(BANNER, IMG_WIZBAN_NPROJ);

	public static final ImageDescriptor DESC_K_OVR = create(OVR, "K2_ovr.png");
	public static final ImageDescriptor DESC_ERROR_OVR = create(OVR, "error_co.gif");
	public static final ImageDescriptor DESC_WARNING_OVR = create(OVR, "warning_co.gif");
	
	public static final ImageDescriptor DESC_VIEW_VARIABLE_TAB = createManaged(VIEW, IMG_VIEW_VARIABLE_TAB);
	
	public static final ImageDescriptor DESC_OBJ_KENYA_APP = createManaged(OBJECT, IMG_OBJ_KENYA_APP);
	public static final ImageDescriptor DESC_OBJ_CLASS = createManaged(OBJECT, IMG_OBJ_CLASS);
	public static final ImageDescriptor DESC_OBJ_FIELD_PUBLIC = createManaged(OBJECT, IMG_OBJ_FIELD_PUBLIC);
	public static final ImageDescriptor DESC_OBJ_METH_PUBLIC = createManaged(OBJECT, IMG_OBJ_METH_PUBLIC);
	public static final ImageDescriptor DESC_OBJ_VAR_LOCAL = createManaged(OBJECT, IMG_OBJ_VAR_LOCAL);
	
	public static final ImageDescriptor DESC_ELCL_CODE_ASSIST = create(ELCL, "metharg_obj.gif");
	public static final ImageDescriptor DESC_DLCL_CODE_ASSIST = create(DLCL, "metharg_obj.gif");

}