/*
 * Created on 12-Nov-2004
 */
package kenya.eclipse.ui;

import kenya.eclipse.KenyaConstants;
import kenya.eclipse.KenyaPlugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;

/**
 * @author Thomas Timbul
 */
public class KenyaLabelDecorator extends LabelProvider
                     implements ILightweightLabelDecorator {
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ILightweightLabelDecorator#decorate(java.lang.Object,
	 *      org.eclipse.jface.viewers.IDecoration)
	 */
	public void decorate(Object element, IDecoration decoration) {
		if(element instanceof IProject) {
			IProject proj = (IProject)element;
			if(!proj.isAccessible()) {
				return;
			}
			try {
				if(proj.hasNature(KenyaConstants.K_NATURE_ID)) {
					decoration.addOverlay(KenyaImages.DESC_K_OVR);
				}
			} catch(CoreException e) {
				KenyaPlugin.log(e);
			}
		} else if(element instanceof IFile) {
			IFile file = (IFile)element;
			if(KenyaConstants.EXTENSION_k.equals(file.getFileExtension())) {
				//add a decorator depending on the severity found
				int severity = calculateMaxMarkerSeverity(file);
				switch(severity) {
					case IMarker.SEVERITY_WARNING:
						decoration.addOverlay(KenyaImages.DESC_WARNING_OVR, IDecoration.BOTTOM_LEFT);
						return;
					case IMarker.SEVERITY_ERROR:
						decoration.addOverlay(KenyaImages.DESC_ERROR_OVR, IDecoration.BOTTOM_LEFT);
						return;
					default:
						break;
				}
			}
		}
	}
	
	static int calculateMaxMarkerSeverity(IFile file) {
		int severity = -1;
		try {
			IMarker[] ms
			= file.findMarkers(IMarker.PROBLEM, true, IFile.DEPTH_INFINITE);
			
			//find the most appropriate severity:
			// error if ANY errors,
			// warning if no errors but ANY warnings,
			// -1 (none) otherwise
			search:
			for(int i=0; i<ms.length; i++) {
				switch(ms[i].getAttribute(IMarker.SEVERITY, severity)) {
					case IMarker.SEVERITY_ERROR:
						severity = IMarker.SEVERITY_ERROR;
					break search;
					case IMarker.SEVERITY_WARNING:
						severity = IMarker.SEVERITY_WARNING;
					break;
					default:
						break;
				}
			}
		} catch(CoreException e) {
			KenyaPlugin.log(e);
		}
		return severity;
	}
	
	public boolean isLabelProperty(Object element, String property) {
	    return true;
	}
	
}