package kenya.eclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;

import kenya.eclipse.KenyaConstants;
import kenya.eclipse.KenyaPlugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class NewKenyaProjectCreationOperation implements IRunnableWithProgress {

	private NewKenyaProjectCreationWizardPage[] fPages;
	
	/**
	 * Constructor for ExampleProjectCreationOperation
	 */
	public NewKenyaProjectCreationOperation(NewKenyaProjectCreationWizardPage[] pages) {
		fPages= pages;
	}
	
	/*
	 * @see IRunnableWithProgress#run(IProgressMonitor)
	 */
	public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
		if (monitor == null) {
			monitor= new NullProgressMonitor();
		}
		try {
			monitor.beginTask(NewKenyaProjectConstants.op_desc, fPages.length);
			IWorkspaceRoot root= KenyaPlugin.getWorkspace().getRoot();
			
			for (int i= 0; i < fPages.length; i++) {
				createProject(root, fPages[i], new SubProgressMonitor(monitor, 1));
			}
		} finally {
			monitor.done();
		}
	}		
	

	private void createProject(IWorkspaceRoot root, NewKenyaProjectCreationWizardPage page, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
		
		monitor.beginTask(NewKenyaProjectConstants.op_desc_proj, 1);
		
		String name= page.getName();
		
		String[] natureIds = {KenyaConstants.K_NATURE_ID};
		
		configNewProject(root, name, natureIds, monitor);
		
	}
	
	private IProject configNewProject(IWorkspaceRoot root, String name, String[] natureIds, IProgressMonitor monitor) throws InvocationTargetException {
		try {
			IProject project= root.getProject(name);
			if (!project.exists()) {
				project.create(null);
			}
			if (!project.isOpen()) {
				project.open(null);
			}
			IProjectDescription desc = project.getDescription();
			desc.setLocation(null);
			desc.setNatureIds(natureIds);
			
			project.setDescription(desc, new SubProgressMonitor(monitor, 1));

			return project;
		} catch (CoreException e) {
			throw new InvocationTargetException(e);
		}
	}
	
}
