package kenya.eclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;

import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.ui.KenyaImages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewProjectCreationWizard extends Wizard implements INewWizard, IExecutableExtension {
	
	private IConfigurationElement fConfigElement;
	private NewKenyaProjectCreationWizardPage[] fPages;
	
	public NewProjectCreationWizard() {
		super();
		setDialogSettings(KenyaPlugin.getDefault().getDialogSettings());
		setWindowTitle("New Kenya Project");
		setNeedsProgressMonitor(true);
	}
	
	/*
	 * @see Wizard#addPages
	 */	
	public void addPages() {
		super.addPages();
		
		fPages = new NewKenyaProjectCreationWizardPage[1];
		for (int i= 0; i < fPages.length; i++) {
			fPages[i]= new NewKenyaProjectCreationWizardPage("page "+i);
			addPage(fPages[i]);
		}
	}
	
	/*
	 * @see Wizard#performFinish
	 */		
	public boolean performFinish() {
		NewKenyaProjectCreationOperation runnable= new NewKenyaProjectCreationOperation(fPages);
		
		IRunnableWithProgress op= new WorkspaceModifyDelegatingOperation(runnable);
		try {
			getContainer().run(false, true, op);
		} catch (InvocationTargetException e) {
			handleException(e.getTargetException());
			return false;
		} catch  (InterruptedException e) {
			return false;
		}
		BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
		return true;
	}
	
	private void handleException(Throwable target) {
		String title= NewKenyaProjectConstants.op_errorTitle;
		String message= NewKenyaProjectConstants.op_errorMessage;
		if (target instanceof CoreException) {
			IStatus status= ((CoreException)target).getStatus();
			ErrorDialog.openError(getShell(), title, message, status);
			KenyaPlugin.log(status);
		} else {
			MessageDialog.openError(getShell(), title, target.getMessage());
			KenyaPlugin.log(target);
		}
	}
	
	/**
	 * Stores the configuration element for the wizard.  The config element will be used
	 * in <code>performFinish</code> to set the result perspective.
	 */
	public void setInitializationData(
				IConfigurationElement cfig,
				String propertyName,
				Object data
			) {
		fConfigElement= cfig;
		this.setDefaultPageImageDescriptor(
				KenyaImages.DESC_K_NPROJ_WIZBAN
			);
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {

	}		
}
