/*
 * Created on 24-Oct-2004
 */
package kenya.eclipse;

import kenya.eclipse.preferences.PreferenceConstants;

/**
 * @author Thomas Timbul
 */
public interface KenyaConstants {
	
	/**
	 * Extension point identifier for contributions of KenyaPostBuildAnalyserFactories
	 */
	public static final String EXTENSION_POINT_BUILD_PARTICIPANT = "postBuildAnalyserFactories";
	
	/*##################################################
	 *#                                                #
	 *#             component identifiers              #
	 *#                                                #
	 *##################################################
	 */
	
	/**
	 * KenyaPlugin ID (kenya.eclipse)
	 */
	public static final String K_PLUGIN_ID = "kenya.eclipse";
	
	/**
	 * Kenya Resource Navigator ID (kenya.eclipse.ui.views.KenyaResourceNavigator)
	 */
	public static final String VIEW_K_RES_NAV_ID = "kenya.eclipse.ui.views.KenyaResourceNavigator";
	
	/**
	 * Kenya Document Overview ID (kenya.eclipse.ui.views.KenyaDocumentOverview)
	 */
	public static final String VIEW_K_DOC_OVERVIEW_ID = "kenya.eclipse.ui.views.KenyaDocumentOverview";
	
	/**
	 * Kenya Perspective ID (kenya.eclipse.ui.perspectives.KenyaPerspectiveFactory)
	 */
	public static final String K_PERSPECTIVE_ID = "kenya.eclipse.ui.perspectives.KenyaPerspectiveFactory";
	
	/**
	 * Kenya Preference Page ID (kenya.eclipse.preferences.KenyaPreferencePage)
	 */
	public static final String K_PREF_PAGE_ID = "kenya.eclipse.preferences.KenyaPreferencePage";
	
	/**
	 * Kenya Editor ID (kenya.eclipse.editors.EditingWindow)
	 */
	public static final String K_EDITOR_ID = "kenya.eclipse.editors.EditingWindow";
	
	/**
	 * New Kenya Project Creation Wizard ID (kenya.eclipse.ui.wizards.NewProjectCreationWizard)
	 */
	public static final String NEW_K_PRJ_WIZ_ID = "kenya.eclipse.ui.wizards.NewProjectCreationWizard";
	
	/**
	 * Kenya Project Nature ID (kenya.eclipse.kenyanature)
	 */
	public static final String K_NATURE_ID = K_PLUGIN_ID+".kenyanature";
	
	/**
	 * Kenya Project Nature Resource Decorator ID (kenya.naturedecorator)
	 */
	public static final String K_PROJECT_DECORATOR = "kenya.naturedecorator";
	
	/**
	 * Kenya file Resource Decorator ID (kenya.filedecorator)
	 */
	public static final String ERRORED_FILE_DECORATOR_ID = "kenya.filedecorator";
	
	
	/*##################################################
	 *#                                                #
	 *#                filename constants              #
	 *#                                                #
	 *##################################################
	 */
	
	/**
	 * Kenya file extension ("k")
	 */
	public static final String EXTENSION_k = "k";
	
	/**
	 * Kenya file suffix as String (".k")
	 */
	public static final String SUFFIX_STRING_k = "."+EXTENSION_k;
	
	/**
	 * Kenya file suffix as char array ( {'.', 'k'} )
	 */
	public static final char[] SUFFIX_k = SUFFIX_STRING_k.toCharArray();

	public final static String KENYA_PARTITIONING= "__kenya_partitioning";
	

	/*##################################################
	 *#                                                #
	 *#                    other                       #
	 *#                                                #
	 *##################################################
	 */
	
	public static final int EDITOR_TAB_WIDTH = KenyaPlugin.getDefault().getPreferenceStore().getInt(PreferenceConstants.EDITOR_TAB_WIDTH);
	public static final boolean USING_TAB_CHARACTER = true;
	
}
