/*
 * Created on 23-Feb-2005
 */
package kenya.eclipse.debug;

import kenya.eclipse.debug.model.KenyaDebugElement;
import kenya.eclipse.debug.model.KenyaDebugTarget;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;

/**
 * @author Thomas Timbul
 */
public class AdapterDebugTarget extends KenyaDebugElement implements IDebugTarget {
	
	protected AbstractVKProcess fProcess;
	
	// containing launch object
	protected ILaunch fLaunch;
	
	// program name
	protected String fName;
	
	public AdapterDebugTarget(ILaunch launch, AbstractVKProcess process, String name) {
		super(null);
		
		fLaunch = launch;
		fProcess = process;
		fName = name;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		if(adapter == IDebugTarget.class) {
			return this;
		} else if(adapter == KenyaDebugTarget.class) {
			return fTarget;
		} else if(adapter == AbstractVKProcess.class) {
			return fProcess;
		} else if(adapter == IProcessStreamManager.class) {
			return fProcess.getStreamManager();
		} else {
			return super.getAdapter(adapter);
		}
	}
	
	/////////////////////////////////////////////
	/////////////////////////////////////////////
	//
	// methods inherited from IDebugTarget
	//
	/////////////////////////////////////////////
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IDebugTarget#getProcess()
	 */
	public IProcess getProcess() {
		return getLaunch().getProcesses()[0];
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IDebugTarget#getThreads()
	 */
	public IThread[] getThreads() throws DebugException {
		return new IThread[0];
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IDebugTarget#hasThreads()
	 */
	public boolean hasThreads() throws DebugException {
		return false;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IDebugTarget#getName()
	 */
	public String getName() throws DebugException {
		return fName;
	}

	/////////////////////////////////////////////
	/////////////////////////////////////////////
	//
	// other inherited methods
	//
	/////////////////////////////////////////////

	public ILaunch getLaunch() {
		return fLaunch;
	}

	public boolean canDisconnect() {
		return false;
	}

	public void disconnect() throws DebugException {
		unsupported("disconnect not supported");
	}

	public boolean isDisconnected() {
		return false;
	}

	public boolean supportsStorageRetrieval() {
		return false;
	}

	public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
		unsupported("storage retrieval not supported");
		return null;
	}
	
	public boolean supportsBreakpoint(IBreakpoint breakpoint) {
		return false;
	}
	public boolean canTerminate() {
		return getProcess().canTerminate();
	}
	public boolean isTerminated() {
		return getProcess().isTerminated();
	}
	public void terminate() throws DebugException {
		getProcess().terminate();
	}
	public boolean canResume() {
		return false;
	}
	public boolean canSuspend() {
		return false;
	}
	public boolean isSuspended() {
		return false;
	}
	public void resume() throws DebugException {
	}
	public void suspend() throws DebugException {
	}
	public void breakpointAdded(IBreakpoint breakpoint) {
	}
	public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
	}
	public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
	}
}
