/*
 * Created on 25-Dec-2004
 */
package kenya.eclipse.debug.bridge;

import java.lang.reflect.InvocationTargetException;


/**
 * Creates a channel over which two communicators can remote invoke methods in
 * each other without having a direct reference to each other.
 * 
 * @author Thomas Timbul
 */
public interface ICommunicationBridge {
	
	public static final int A_POSITION = 0;
	public static final int B_POSITION = 1;
	public static final int FREE_POSITION = 2;
	
	/**
	 * equivalent to setPort(comm, FREE_POSITION)
	 * This method is preferred because it does not specify a position (which
	 * would create an implicit dependency by having to know which communicator is
	 * in which position).
	 * @param comm communicator to add
	 */
	public void addPort(IBridgeCommunicator comm);
	
	/**
	 * adds the given communicator into the specified position, replacing any
	 * previous communicator in that position. If pos is FREE_POSITION, the
	 * communicator is placed in some position where
	 * there is currently a null object.
	 * 
	 * @param comm
	 * @param pos one of A_POSITION, B_POSITION or FREE_POSITION
	 */
	public void setPort(IBridgeCommunicator comm, int pos);
	
	/**
	 * invokes a remote method with given name and arguments on the target.
	 * The target is the respective other communicator registered with this bridge
	 * than source.<br>An exception is thrown if
	 * <ul>
	 * <li>the source is unknown to this bridge
	 * <li>the target is null
	 * <li>another exception occurrs in the target
	 * </ul> 
	 * @param source the communicator originating the call
	 * @param methName name of the method to invoke
	 * @param args arguments for the method call
	 * @return the result of the invocation, or null if a void method
	 * @throws InvocationTargetException see description
	 */
	public Object invokeRemote(IBridgeCommunicator source, String methName, Object[] args) throws InvocationTargetException;
	
}