/*
 * Created on 30-Dec-2004
 */
package kenya.eclipse.debug.model.values;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Map.Entry;

import kenya.eclipse.debug.model.KVariable;
import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.sourceCodeInformation.interfaces.IVariable;
import mediator.stackMachine.IStackMachineInformationProvider;

import org.eclipse.debug.core.DebugException;
import org.wellquite.kenya.stackMachine.types.interfaces.IClassInstanceType;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClass;
import org.wellquite.kenya.stackMachine.types.interfaces.IInterpretedClassInstance;

/**
 * represents an IClassInstanceType as an IValue in the debugging model
 * @author Thomas Timbul
 */
public class KClassValue extends KValue {
	
	private HashMap fVarMap = new HashMap();
	
	/*package*/ KClassValue(KenyaDebugTarget target, IVariable var, IClassInstanceType type) {
		super(target, var);
		fType = type;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getValueString()
	 */
	public String getValueString() throws DebugException {
		IStackMachineInformationProvider ismip = null;
		try {
			ismip = fTarget.getStackMachineInformationProvider();
		} catch(InvocationTargetException e) {
			return ( (IClassInstanceType)fType ).getValueClassName();
		}
		IInterpretedClass c = ( (IClassInstanceType)fType ).getValue().getInterpretedClass();
		String name = ismip.lookupClass(c.getName()).getName();
		return name;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getVariables()
	 */
	public org.eclipse.debug.core.model.IVariable[] getVariables()
			throws DebugException {
		IInterpretedClassInstance c = ( (IClassInstanceType)fType ).getValue();
		
		Set entries = new HashSet();
		
		entries.addAll(c.getImmutableInstanceVariables().entrySet());
		entries.addAll(c.getMutableInstanceVariables().entrySet());
		
		KVariable[] v = new KVariable[entries.size()];
		
		int i=0;
		for(Iterator it=entries.iterator(); it.hasNext(); i++) {
			Entry e = (Entry)it.next();
			v[i] = (KVariable)fVarMap.get(e);
			if(v[i]==null) {
				v[i] = new KVariable(fTarget, e);
				fVarMap.put(e, v[i]);
			}
		}
		
		return v;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#hasVariables()
	 */
	public boolean hasVariables() throws DebugException {
		IInterpretedClassInstance c = ( (IClassInstanceType)fType ).getValue();
		
		return c.getImmutableInstanceVariables().size() > 0
		    || c.getMutableInstanceVariables()  .size() > 0;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#isValueEqual(kenya.eclipse.debug.model.values.KValue)
	 */
	public boolean isValueEqual(KValue val) {
		try {
			if(val instanceof KClassValue) {
				KClassValue v = (KClassValue)val;
				boolean eq = v.fType.getTypeName().equals(fType.getTypeName());
				KVariable[] vvars = (KVariable[])v.getVariables();
				KVariable[] vars = (KVariable[])getVariables();
				if(vvars.length!=vars.length) {
					return false;
				}
				for(int i=0; i<vvars.length; i++) {
					eq &= vvars[i].isValueEqual(vars[i]);
				}
				
				return eq;
			}
		} catch(DebugException e) {
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#clone()
	 */
	public Object clone() {
		KClassValue v = (KClassValue)super.clone();
		v.fVarMap = fVarMap;
		return v;
	}
	
}
