/*
 * Created on 30-Dec-2004
 */
package kenya.eclipse.debug.model.values;

import kenya.eclipse.debug.model.KenyaDebugTarget;
import kenya.sourceCodeInformation.interfaces.IVariable;

import org.eclipse.debug.core.DebugException;
import org.wellquite.kenya.stackMachine.types.interfaces.IPrimitiveType;

/**
 * represents an IPrimitiveType as an IValue in the debugging model.
 * This EX-cludes IArrayType
 * 
 * @author Thomas Timbul
 */
public class KPrimitiveValue extends KValue {
	
	/*package*/ KPrimitiveValue(KenyaDebugTarget target, IVariable var, IPrimitiveType type) {
		super(target, var);
		fType = (IPrimitiveType)type;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getValueString()
	 */
	public String getValueString() throws DebugException {
		return fType.valueToString();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#getVariables()
	 */
	public org.eclipse.debug.core.model.IVariable[] getVariables()
			throws DebugException {
		return new org.eclipse.debug.core.model.IVariable[0];
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IValue#hasVariables()
	 */
	public boolean hasVariables() throws DebugException {
		return false;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#isValueEqual(kenya.eclipse.debug.model.values.KValue)
	 */
	public boolean isValueEqual(KValue val) {
		try {
			if(val instanceof KPrimitiveValue) {
				return getValueString().equals(val.getValueString());
			}
		} catch(DebugException e) {
		}
		return false;
	}
	
	/* (non-Javadoc)
	 * @see kenya.eclipse.debug.model.values.KValue#clone()
	 */
	public Object clone() {
		KPrimitiveValue v = (KPrimitiveValue)super.clone();
		return v;
	}
	
}
