/*
 * Created on 28-Dec-2004
 */
package kenya.eclipse.debug.sourcelookup;

import kenya.eclipse.debug.launcher.IKenyaLaunchConfigurationConstants;
import kenya.eclipse.debug.model.KStackFrame;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;

/**
 * @author Thomas Timbul
 */
public class KenyaSourceLookupParticipant extends
		AbstractSourceLookupParticipant {
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant#getSourceName(java.lang.Object)
	 */
	public String getSourceName(Object object) throws CoreException {
		if(object instanceof KStackFrame) {
			KStackFrame f = (KStackFrame)object;
			ILaunchConfiguration c = f.getLaunch().getLaunchConfiguration();
			String workspaceRelativePath = c.getAttribute(IKenyaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null);
			if(workspaceRelativePath==null) {
				return null;
			}
			
			IPath p = new Path(workspaceRelativePath);
			return p.lastSegment(); //only get the last segment
		}
		return null;
	}

}
