/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package kenya.eclipse.multieditor.java;


import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.multieditor.kenya.KenyaPartitionScanner;
import kenya.eclipse.multieditor.util.DefaultSyntaxColorProvider;
import kenya.eclipse.multieditor.util.KenyaColourManager;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;


/**
 * Example configuration for an <code>SourceViewer</code> which shows Java code.
 */
public class JavaSourceViewerConfiguration extends SourceViewerConfiguration {
	
	/**
	 * Single token scanner.
	 */
	static class SingleTokenScanner extends BufferedRuleBasedScanner {
		public SingleTokenScanner(TextAttribute attribute) {
			setDefaultReturnToken(new Token(attribute));
		}
	}
	
	/**
	 * Default constructor.
	 */
	public JavaSourceViewerConfiguration() {
	}
	
	/* (non-Javadoc)
	 * Method declared on SourceViewerConfiguration
	 */
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		
		KenyaColourManager provider= KenyaPlugin.getDefault().getKenyaColourManager();
		PresentationReconciler reconciler= new PresentationReconciler();
		reconciler.setDocumentPartitioning(getConfiguredDocumentPartitioning(sourceViewer));
		
		DefaultDamagerRepairer dr= new DefaultDamagerRepairer(KenyaPlugin.getDefault().getJavaCodeScanner());
		reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);
		
		dr= new DefaultDamagerRepairer(new SingleTokenScanner(new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.MULTI_LINE_COMMENT))));
		reconciler.setDamager(dr, KenyaPartitionScanner.JAVA_MULTILINE_COMMENT);
		reconciler.setRepairer(dr, KenyaPartitionScanner.JAVA_MULTILINE_COMMENT);

		return reconciler;
	}
	
}
