/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Thomas Timbul - adaptation to Kenya
 *******************************************************************************/
package kenya.eclipse.multieditor.kenya;

import org.eclipse.ui.texteditor.ITextEditorActionDefinitionIds;

/**
 * Defines the definition IDs for the Kenya editor actions.
 * 
 * <p>
 * This interface is not intended to be implemented or extended.
 * </p>.
 * <p><b>This interface has been adapted from its original in JDT.
 * Many actions are therefore omitted.</b></p>
 */
public interface IKenyaEditorActionDefinitionIds extends ITextEditorActionDefinitionIds {

	// edit

	/**
	 * Action definition ID of the edit -> correction assist proposal action
	 * (value <code>"kenya.eclipse.multieditor.kenya.correction.assist.proposals"</code>).
	 */
	public static final String CORRECTION_ASSIST_PROPOSALS= "kenya.eclipse.multieditor.kenya.correction.assist.proposals"; //$NON-NLS-1$
	
	/**
	 * Action definition ID of the edit -> content assist complete prefix action
	 * (value: <code>"kenya.eclipse.multieditor.kenya.complete.prefix"</code>).
	 * @since 3.0
	 */
	public static final String CONTENT_ASSIST_COMPLETE_PREFIX= "kenya.eclipse.multieditor.kenya.complete.prefix"; //$NON-NLS-1$

	// source
	
	/**
	 * Action definition ID of the source -> comment action
	 * (value <code>"kenya.eclipse.multieditor.kenya.comment"</code>).
	 */
	public static final String COMMENT= "kenya.eclipse.multieditor.kenya.comment"; //$NON-NLS-1$
	
	/**
	 * Action definition ID of the source -> uncomment action
	 * (value <code>"kenya.eclipse.multieditor.kenya.uncomment"</code>).
	 */
	public static final String UNCOMMENT= "kenya.eclipse.multieditor.kenya.uncomment"; //$NON-NLS-1$
	
	/**
	 * Action definition ID of the source -> toggle comment action
	 * (value <code>"kenya.eclipse.multieditor.kenya.toggle.comment"</code>).
	 * @since 3.0
	 */
	public static final String TOGGLE_COMMENT= "kenya.eclipse.multieditor.kenya.toggle.comment"; //$NON-NLS-1$
	
	/**
	 * Action definition ID of the source -> add block comment action
	 * (value <code>"kenya.eclipse.multieditor.kenya.add.block.comment"</code>).
	 * @since 3.0
	 */
	public static final String ADD_BLOCK_COMMENT= "kenya.eclipse.multieditor.kenya.add.block.comment"; //$NON-NLS-1$

	/**
	 * Action definition ID of the source -> remove block comment action
	 * (value <code>"kenya.eclipse.multieditor.kenya.remove.block.comment"</code>).
	 * @since 3.0
	 */
	public static final String REMOVE_BLOCK_COMMENT= "kenya.eclipse.multieditor.kenya.remove.block.comment"; //$NON-NLS-1$
	
	/**
	 * Action definition ID of the source -> indent action
	 * (value <code>"kenya.eclipse.multieditor.kenya.indent"</code>).
	 */
	public static final String INDENT= "kenya.eclipse.multieditor.kenya.indent"; //$NON-NLS-1$
	
	/**
	 * Action definition ID of the source -> format action
	 * (value <code>"kenya.eclipse.multieditor.kenya.format"</code>).
	 */
	public static final String FORMAT= "kenya.eclipse.multieditor.kenya.format"; //$NON-NLS-1$
	
	// refactor
	
	/**
	 * Action definition ID of the refactor -> rename element action
	 * (value <code>"kenya.eclipse.multieditor.kenya.rename.element"</code>).
	 */
	public static final String RENAME_ELEMENT= "kenya.eclipse.multieditor.kenya.rename.element"; //$NON-NLS-1$
	
	// navigate
	
	// search
	
	// miscellaneous
	
	/**
	 * Action definition ID of the toggle text hover tool bar button action
	 * (value <code>"kenya.eclipse.multieditor.kenya.toggle.text.hover"</code>).
	 */
	public static final String TOGGLE_TEXT_HOVER= "kenya.eclipse.multieditor.kenya.toggle.text.hover"; //$NON-NLS-1$

	/**
	 * Action definition ID of the remove occurrence annotations action
	 * (value <code>"org.eclipse.jdt.ui.edit.text.remove.occurrence.annotations"</code>).
	 * @since 3.0
	 */
	public static final String REMOVE_OCCURRENCE_ANNOTATIONS= "org.eclipse.jdt.ui.edit.text.remove.occurrence.annotations";  //$NON-NLS-1$

	/**
	 * Action definition id of toggle mark occurrences action
	 * (value: <code>"kenya.eclipse.multieditor.kenya.toggleMarkOccurrences"</code>).
	 * @since 3.0
	 */
	public static final String TOGGLE_MARK_OCCURRENCES= "kenya.eclipse.multieditor.kenya.toggleMarkOccurrences"; //$NON-NLS-1$
}
