/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package kenya.eclipse.multieditor.kenya;

import java.util.ResourceBundle;

import kenya.eclipse.style.KenyaStyleManager;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SelectAnnotationRulerAction;

/**
 * A special select marker ruler action which activates quick fix if clicked on a quick fixable problem.
 */
public class KenyaSelectMarkerRulerAction2 extends SelectAnnotationRulerAction {
	
	/** Id of the no breakpoint fake annotation */
	public static final String NO_BREAKPOINT_ANNOTATION= "org.eclipse.jdt.internal.ui.NoBreakpointAnnotation"; //$NON-NLS-1$
	
	public KenyaSelectMarkerRulerAction2(ResourceBundle bundle, String prefix, ITextEditor editor) {
		super(bundle, prefix, editor);
//		WorkbenchHelp.setHelp(this, IJavaHelpContextIds.JAVA_SELECT_MARKER_RULER_ACTION);
	}
	
	/*
	 * @see org.eclipse.ui.texteditor.IVerticalRulerListener#annotationDefaultSelected(org.eclipse.ui.texteditor.VerticalRulerEvent)
	 */
	public void annotationDefaultSelected(VerticalRulerEvent event) {
		Annotation annotation= event.getSelectedAnnotation();
		IAnnotationModel model= getAnnotationModel();
		
		if (isBreakpoint(annotation))
			triggerAction(ITextEditorActionConstants.RULER_DOUBLE_CLICK);
		
		Position position= model.getPosition(annotation);
		if (position == null)
			return;
		
		if (isQuickFixTarget(annotation)) {
			ITextOperationTarget operation= (ITextOperationTarget) getTextEditor().getAdapter(ITextOperationTarget.class);
			final int opCode= KenyaEditor.CORRECTIONASSIST_PROPOSALS;
			if (operation != null && operation.canDoOperation(opCode)) {
				getTextEditor().selectAndReveal(position.getOffset(), position.getLength());
				operation.doOperation(opCode);
				return;
			}
		}
		
		// default:
		super.annotationDefaultSelected(event);
	}
	
	/**
	 * @param annotation
	 * @return
	 */
	private boolean isBreakpoint(Annotation annotation) {
		return annotation.getType().equals("org.eclipse.debug.core.breakpoint")
		  || annotation.getType().equals(NO_BREAKPOINT_ANNOTATION);
	}

	private boolean isQuickFixTarget(Annotation a) {
		if (a instanceof MarkerAnnotation) {
			MarkerAnnotation ma = (MarkerAnnotation)a;
			return KenyaStyleManager.getResolutionManager().hasResolutions(ma.getMarker());
		}
		return false;
	}

	private void triggerAction(String actionID) {
		IAction action= getTextEditor().getAction(actionID);
		if (action != null) {
			if (action instanceof IUpdate)
				((IUpdate) action).update();
			// hack to propagate line change
			if (action instanceof ISelectionListener) {
				((ISelectionListener)action).selectionChanged(null, null);
			}
			if (action.isEnabled())
				action.run();
		}
	}

}

