/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Thomas Timbul - adaptation to Kenya Plugin
 *******************************************************************************/

package kenya.eclipse.multieditor.kenya;


import kenya.eclipse.KenyaConstants;
import kenya.eclipse.KenyaPlugin;
import kenya.eclipse.multieditor.kenya.completion.KenyaCompletionProcessor;
import kenya.eclipse.multieditor.kenya.util.KenyaAutoIndentStrategy;
import kenya.eclipse.multieditor.kenya.util.KenyaDoubleClickSelector;
import kenya.eclipse.multieditor.text.JavaFormattingStrategy;
import kenya.eclipse.multieditor.util.DefaultSyntaxColorProvider;

import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

/**
 * @author Thomas Timbul
 */
public class KenyaSourceViewerConfiguration extends SourceViewerConfiguration {
	
	/**
	 * Single token scanner.
	 */
	static class SingleTokenScanner extends BufferedRuleBasedScanner {
		public SingleTokenScanner(TextAttribute attribute) {
			setDefaultReturnToken(new Token(attribute));
		}
	}
	
	/**
	 * Default constructor
	 */
	public KenyaSourceViewerConfiguration() {
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getAnnotationHover(org.eclipse.jface.text.source.ISourceViewer)
	 */
	public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
		return new KenyaAnnotationHover(KenyaAnnotationHover.VERTICAL_RULER_HOVER);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getOverviewRulerAnnotationHover(org.eclipse.jface.text.source.ISourceViewer)
	 */
	public IAnnotationHover getOverviewRulerAnnotationHover(
			ISourceViewer sourceViewer) {
		return new KenyaAnnotationHover(KenyaAnnotationHover.OVERVIEW_RULER_HOVER);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getTabWidth(org.eclipse.jface.text.source.ISourceViewer)
	 */
	public int getTabWidth(ISourceViewer sourceViewer) {
		return KenyaConstants.EDITOR_TAB_WIDTH;
	}
	
	/*
	 * @see SourceViewerConfiguration#getTextHover(ISourceViewer, String, int)
	 * @since 2.1
	 */
	public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
		//		KenyaEditorTextHoverDescriptor[] hoverDescs= KenyaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
		//		int i= 0;
		//		while (i < hoverDescs.length) {
		//			if (hoverDescs[i].isEnabled() &&  hoverDescs[i].getStateMask() == stateMask)
		//				return new JavaEditorTextHoverProxy(hoverDescs[i], getEditor());
		//			i++;
		//		}
		
		return null;
	}
	
	/*
	 * @see SourceViewerConfiguration#getTextHover(ISourceViewer, String)
	 */
	public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
		return getTextHover(sourceViewer, contentType, ITextViewerExtension2.DEFAULT_HOVER_STATE_MASK);
	}
	
	public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
		return new IAutoEditStrategy[]{getAutoEditStrategy(sourceViewer, contentType)};
	}
	
	protected IAutoEditStrategy getAutoEditStrategy(ISourceViewer sourceViewer, String contentType) {
		//look at JavaAutoIndentStrategy
		//JavaEditorErrorTickUpdater
		//JavaSourceViewer
		
		return (IDocument.DEFAULT_CONTENT_TYPE.equals(contentType) ? new KenyaAutoIndentStrategy() : new DefaultIndentLineAutoEditStrategy());
	}
	
	/*
	 * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getConfiguredDocumentPartitioning(org.eclipse.jface.text.source.ISourceViewer)
	 */
	public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
		return KenyaConstants.KENYA_PARTITIONING;
	}
	
	/* (non-Javadoc)
	 * Method declared on SourceViewerConfiguration
	 */
	public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
		return new String[] { IDocument.DEFAULT_CONTENT_TYPE, KenyaPartitionScanner.JAVA_MULTILINE_COMMENT };
	}
	
	/* (non-Javadoc)
	 * Method declared on SourceViewerConfiguration
	 */
	public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
		
		ContentAssistant assistant= new ContentAssistant();
		assistant.setDocumentPartitioning(getConfiguredDocumentPartitioning(sourceViewer));
		assistant.setContentAssistProcessor(new KenyaCompletionProcessor(), IDocument.DEFAULT_CONTENT_TYPE);
		
		assistant.enableAutoActivation(true);
		assistant.setAutoActivationDelay(300);
		assistant.setProposalPopupOrientation(IContentAssistant.PROPOSAL_OVERLAY);
		assistant.setContextInformationPopupOrientation(IContentAssistant.CONTEXT_INFO_ABOVE);
		assistant.setContextInformationPopupBackground(KenyaPlugin.getDefault().getKenyaColourManager().getColor(new RGB(255, 255, 255)));
		
		return assistant;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getContentFormatter(org.eclipse.jface.text.source.ISourceViewer)
	 */
	public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
		final MultiPassContentFormatter formatter = new MultiPassContentFormatter(
				getConfiguredDocumentPartitioning(sourceViewer),
				IDocument.DEFAULT_CONTENT_TYPE);
		
		formatter.setMasterStrategy(new JavaFormattingStrategy());
		
		return null;//formatter;
	}
	
	
	/* (non-Javadoc)
	 * Method declared on SourceViewerConfiguration
	 */
	public String getDefaultPrefix(ISourceViewer sourceViewer, String contentType) {
		return (IDocument.DEFAULT_CONTENT_TYPE.equals(contentType) ? "//" : null); //$NON-NLS-1$
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getDefaultPrefixes(org.eclipse.jface.text.source.ISourceViewer, java.lang.String)
	 */
	public String[] getDefaultPrefixes(ISourceViewer sourceViewer,
			String contentType) {
		if(contentType==null) {
			return null;
		} else if(contentType.equals(IDocument.DEFAULT_CONTENT_TYPE)) {
			return new String[]{this.getDefaultPrefix(sourceViewer, contentType)};
		} else {
			return super.getDefaultPrefixes(sourceViewer, contentType);
		}
	}
	
	/* (non-Javadoc)
	 * Method declared on SourceViewerConfiguration
	 */
	public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
		return new KenyaDoubleClickSelector();
	}
	
	/* (non-Javadoc)
	 * Method declared on SourceViewerConfiguration
	 */
	public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
		return new String[] { "\t", "    " }; //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	/* (non-Javadoc)
	 * Method declared on SourceViewerConfiguration
	 */
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		
		DefaultSyntaxColorProvider provider= KenyaPlugin.getDefault().getSyntaxColorProvider();
		PresentationReconciler reconciler= new PresentationReconciler();
		reconciler.setDocumentPartitioning(getConfiguredDocumentPartitioning(sourceViewer));
		
		DefaultDamagerRepairer dr= new DefaultDamagerRepairer(KenyaPlugin.getDefault().getKenyaCodeScanner());
		reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);
		
		dr= new DefaultDamagerRepairer(new SingleTokenScanner(new TextAttribute(provider.getColor(DefaultSyntaxColorProvider.MULTI_LINE_COMMENT))));
		reconciler.setDamager(dr, KenyaPartitionScanner.JAVA_MULTILINE_COMMENT);
		reconciler.setRepairer(dr, KenyaPartitionScanner.JAVA_MULTILINE_COMMENT);
		
		return reconciler;
	}
	
//	/* (non-Javadoc)
//	 * Method declared on SourceViewerConfiguration
//	 */
//	public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
//		return new JavaTextHover();
//	}

}
