/*
 * Created on 08-Mar-2005
 */
package kenya.eclipse.multieditor.kenya.completion;

import kenya.eclipse.ast.NodeToString;
import minijava.node.PType;
import minijava.node.TIdentifier;

/**
 * @author Thomas Timbul
 */
public class TypeIdentifierPair {
	
	private PType fType;
	private TIdentifier fId;
	private boolean local;
	
	/**
	 * 
	 */
	public TypeIdentifierPair(PType type, TIdentifier tid, boolean local) {
		fType = type;
		fId = tid;
		this.local = local;
	}
	
	
	public TIdentifier getId() {
		return fId;
	}
	
	public String getIdString() {
		return NodeToString.toString(fId);
	}
	
	public PType getType() {
		return fType;
	}
	
	public String getTypeString() {
		return NodeToString.toString(fType);
	}
	
	public boolean isLocal() {
		return local;
	}
	
	public boolean equals(Object o) {
		return (o instanceof TypeIdentifierPair && equals((TypeIdentifierPair)o));
	}
	
	public boolean equals(TypeIdentifierPair o) {
		String t1 = NodeToString.toString(o.fId);
		String t2 = NodeToString.toString(fId);
		if(!t1.equals(t2)) return false;
		t1 = NodeToString.toString(o.fType);
		t2 = NodeToString.toString(fType);
		return t1.equals(t2);
	}
	
}
