/*
 * Created on 11-Feb-2005
 */
package kenya.eclipse.multieditor.kenya.refactoring;

import java.util.LinkedList;


/**
 * @author Thomas Timbul
 */
public class SortedOperationList implements Cloneable {
	
	private LinkedList fList;
	private int middle = -1;
	
	/**
	 * 
	 */
	public SortedOperationList() {
		fList = new LinkedList();
	}
	
	public void add(DocumentTextOperation o) {
		//sorts on o.fOffset
		
		int adder = 1; //default
		int start = Math.max(middle, 0);
		if(middle>0) {
			int off = ((DocumentTextOperation)fList.get(middle)).fOffset;
			int diff = o.fOffset - off; //+ve if o is later
			adder = diff/Math.abs(diff); //1 if diff is positive, else -1
		}
		if(fList.size()==0) {
			fList.add(o);
		} else {
			final int currSize = fList.size(); //size will change, so don't calculate it in the loop
			for(int i = start; 0<=i && i<=currSize; i+=adder) {
				if(i==fList.size() ||
						((DocumentTextOperation)fList.get(i)).fOffset>o.fOffset
				) {
					fList.add(i, o);
				}
			}
		}
		
		middle = fList.size()/2;
	}
	
	public boolean remove(DocumentTextOperation o) {
		return fList.remove(o);
	}
	
	public DocumentTextOperation removeFirst() {
		return (DocumentTextOperation)fList.removeFirst();
	}
	
	public DocumentTextOperation removeLast() {
		return (DocumentTextOperation)fList.removeLast();
	}
	
	public DocumentTextOperation[] toArray() {
		return (DocumentTextOperation[])fList.toArray(new DocumentTextOperation[fList.size()]);
	}
	
	/*
	 *  (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		SortedOperationList list = (SortedOperationList)super.clone();
		list.fList.addAll(fList);
		list.middle = middle;
		return list;
	}
	
}
